/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.Scx;
import cool.scx.ScxContext;
import cool.scx.ScxEasyConfig;
import cool.scx.ScxModule;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.NoColumn;
import cool.scx.annotation.ScxModel;
import cool.scx.annotation.ScxService;
import cool.scx.base.BaseModel;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.enumeration.WhereType;
import cool.scx.exception.BadRequestException;
import cool.scx.exception.CustomHttpRequestException;
import cool.scx.exception.HttpRequestException;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CrudWhereBody;
import cool.scx.util.Ansi;
import cool.scx.util.ObjectUtils;
import cool.scx.vo.Json;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@ScxService
public class CRUDHandlerImpl
implements CRUDHandler {
    private static final Map<String, Class<?>> SCX_BEAN_CLASS_NAME_MAPPING = new HashMap();

    private static <T extends BaseModel> BaseService<T> getBaseService(String modelName) throws HttpRequestException {
        try {
            Object o = ScxContext.getBean(CRUDHandlerImpl.getClassByName(modelName.toLowerCase() + "service"));
            return (BaseService)o;
        }
        catch (Exception e) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-crud-service").put("service-name", (Object)modelName.toLowerCase()).sendToClient(ctx));
        }
    }

    private static BaseModel getBaseModel(Map<String, Object> entityMap, String modelName) throws HttpRequestException {
        try {
            return (BaseModel)ObjectUtils.convertValue(entityMap, CRUDHandlerImpl.getClassByName(modelName));
        }
        catch (Exception e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    public static Class<?> getClassByName(String str) {
        return SCX_BEAN_CLASS_NAME_MAPPING.get(str.toLowerCase());
    }

    private static Query getQuery(Class<?> modelClass, Integer limit, Integer page, String orderByColumn, String sortType, List<CrudWhereBody> whereBodyList) throws CustomHttpRequestException {
        Query query = new Query();
        if (limit != null && limit >= 0) {
            if (page != null && page >= 0) {
                query.setPagination(page, limit);
            } else {
                query.setPagination(limit);
            }
        }
        if (orderByColumn != null && sortType != null) {
            query.addOrderBy(orderByColumn, sortType);
        }
        if (whereBodyList != null) {
            for (CrudWhereBody crudWhereBody : whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDHandlerImpl.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDHandlerImpl.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDHandlerImpl.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    query.addWhere(crudWhereBody.fieldName, whereType);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    query.addWhere(crudWhereBody.fieldName, whereType, crudWhereBody.value1);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                query.addWhere(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
            }
        }
        return query;
    }

    private static void checkFieldName(Class<?> modelClass, String fieldName) throws CustomHttpRequestException {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-field-name").put("field-name", (Object)fieldName).sendToClient(ctx));
            }
        }
        catch (Exception e) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-field-name").put("field-name", (Object)fieldName).sendToClient(ctx));
        }
    }

    private static WhereType checkWhereType(String fieldName, String strWhereType) throws CustomHttpRequestException {
        try {
            return WhereType.valueOf((String)strWhereType.toUpperCase());
        }
        catch (Exception ignored) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-where-type").put("field-name", (Object)fieldName).put("where-type", (Object)strWhereType).sendToClient(ctx));
        }
    }

    private static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws CustomHttpRequestException {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"where-body-parameters-size-error").put("field-name", (Object)fieldName).put("where-type", (Object)whereType).put("need-parameters-size", (Object)whereType.paramSize()).put("got-parameters-size", (Object)paramSize.get()).sendToClient(ctx));
        }
    }

    @Override
    public Json list(String modelName, Integer limit, Integer page, String orderByColumn, String sortType, List<CrudWhereBody> whereBodyList) throws HttpRequestException, SQLException {
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        Query queryParam = CRUDHandlerImpl.getQuery(CRUDHandlerImpl.getClassByName(modelName), limit, page, orderByColumn, sortType, whereBodyList);
        List list = baseService.list(queryParam);
        long count = baseService.count(queryParam);
        return Json.ok().put("items", (Object)list).put("total", (Object)count);
    }

    @Override
    public Json info(String modelName, Long id) throws HttpRequestException, SQLException {
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        BaseModel info = baseService.get(id.longValue());
        return Json.ok().put("info", (Object)info);
    }

    @Override
    public Json save(String modelName, Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        if (entityMap == null) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"empty-param").sendToClient(ctx));
        }
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        BaseModel realObject = CRUDHandlerImpl.getBaseModel(entityMap, modelName);
        return Json.ok().put("item", (Object)baseService.save(realObject));
    }

    @Override
    public Json update(String modelName, Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        if (entityMap == null) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"empty-param").sendToClient(ctx));
        }
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        BaseModel realObject = CRUDHandlerImpl.getBaseModel(entityMap, modelName);
        return Json.ok().put("item", (Object)baseService.update(realObject));
    }

    @Override
    public Json delete(String modelName, Integer id) throws HttpRequestException, SQLException {
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        long deleteByIds = baseService.delete(new long[]{id.intValue()});
        return Json.ok().put("delete-result", (Object)(deleteByIds == 1L ? 1 : 0));
    }

    @Override
    public Json batchDelete(String modelName, @FromBody(value="deleteIds") long[] deleteIds) throws HttpRequestException, SQLException {
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        long deletedCount = baseService.delete(deleteIds);
        return Json.ok().put("deletedCount", (Object)deletedCount);
    }

    @Override
    public Json revokeDelete(String modelName, Integer id) throws HttpRequestException, SQLException {
        if (!ScxEasyConfig.tombstone()) {
            return Json.fail((String)"not-used-tombstone");
        }
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        long revokeDeleteCount = baseService.revokeDelete(new long[]{id.intValue()});
        return revokeDeleteCount == 1L ? Json.ok() : Json.fail();
    }

    @Override
    public Json getAutoComplete(String modelName, String fieldName) throws HttpRequestException, SQLException {
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        List fieldList = baseService.getFieldList(fieldName);
        return Json.ok().put("fields", (Object)fieldList);
    }

    @Override
    public Json checkUnique(String modelName, Map<String, Object> params) throws HttpRequestException, SQLException {
        BaseService baseService = CRUDHandlerImpl.getBaseService(modelName);
        BaseModel model = CRUDHandlerImpl.getBaseModel(params, modelName);
        Long modelID = model.id;
        model.id = null;
        Query queryParam = new Query().addWhereByObject(model);
        if (modelID != null) {
            queryParam.addWhere("id", WhereType.NOT_EQUAL, (Object)modelID);
        }
        boolean b = baseService.count(queryParam) == 0L;
        return Json.ok().put("isUnique", (Object)b);
    }

    static {
        for (ScxModule allModule : Scx.getScxModules()) {
            for (Class c : allModule.classList()) {
                if (!c.isAnnotationPresent(ScxService.class) && !c.isAnnotationPresent(ScxModel.class)) continue;
                String className = c.getSimpleName().toLowerCase();
                Class<?> aClass = SCX_BEAN_CLASS_NAME_MAPPING.get(className);
                if (aClass == null) {
                    SCX_BEAN_CLASS_NAME_MAPPING.put(c.getSimpleName().toLowerCase(), c);
                    continue;
                }
                SCX_BEAN_CLASS_NAME_MAPPING.put(c.getName(), c);
                Ansi.out().brightRed((Object)"\u68c0\u6d4b\u5230\u91cd\u590d\u540d\u79f0\u7684 class ").brightYellow((Object)("[" + aClass.getName() + "] ")).blue((Object)("[" + c.getName() + "]")).brightRed((Object)" \u53ef\u80fd\u4f1a\u5bfc\u81f4\u6839\u636e\u540d\u79f0\u8c03\u7528\u65f6\u610f\u4e49\u4e0d\u660e\u786e !!! \u5efa\u8bae\u4fee\u6539 !!!").println();
            }
        }
    }
}

