/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fixtable;

import cool.scx.Scx;
import cool.scx.ScxDao;
import cool.scx.ScxEasyConfig;
import cool.scx.ScxModule;
import cool.scx.annotation.Column;
import cool.scx.annotation.ScxModel;
import cool.scx.bo.TableInfo;
import cool.scx.ext.fixtable.FixTableResult;
import cool.scx.gui.SQLGUIHandler;
import cool.scx.sql.SQLHelper;
import cool.scx.sql.SQLRunner;
import cool.scx.util.Ansi;
import cool.scx.util.CaseUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixTableUtils {
    private static final Logger logger = LoggerFactory.getLogger(FixTableUtils.class);
    private static final String databaseName = ScxEasyConfig.dataSourceDatabase();

    public static void fixTableByScxModel() {
        if (!ScxDao.checkDataSource()) {
            return;
        }
        logger.debug("\u68c0\u67e5\u6570\u636e\u8868\u7ed3\u6784\u4e2d...");
        boolean alreadyShowConfirmFixTable = false;
        int fixSuccess = 0;
        int fixFail = 0;
        int noNeedToFix = 0;
        for (ScxModule scxModule : Scx.getScxModules()) {
            for (Class v : scxModule.classList()) {
                FixTableResult r;
                if (!v.isAnnotationPresent(ScxModel.class) || v.isInterface() || !FixTableUtils.needFixTable(v)) continue;
                if (!alreadyShowConfirmFixTable) {
                    boolean cancelFix;
                    boolean bl = cancelFix = !SQLGUIHandler.confirmFixTable();
                    if (cancelFix) {
                        logger.warn("\u5df2\u53d6\u6d88\u4fee\u590d\u8868...");
                        return;
                    }
                    alreadyShowConfirmFixTable = true;
                }
                if ((r = FixTableUtils.fixTable(v)) == FixTableResult.FIX_SUCCESS) {
                    ++fixSuccess;
                    continue;
                }
                if (r == FixTableResult.FIX_FAIL) {
                    ++fixFail;
                    continue;
                }
                if (r != FixTableResult.NO_NEED_TO_FIX) continue;
                ++noNeedToFix;
            }
        }
        if (fixSuccess != 0) {
            logger.debug("\u4fee\u590d\u6210\u529f {} \u5f20\u8868...", (Object)fixSuccess);
        }
        if (fixFail != 0) {
            logger.warn("\u4fee\u590d\u5931\u8d25 {} \u5f20\u8868...", (Object)fixFail);
        }
        if (fixSuccess + fixFail == 0) {
            logger.debug("\u6ca1\u6709\u8868\u9700\u8981\u4fee\u590d...");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FixTableResult fixTable(Class<?> clazz) {
        TableInfo table = SQLHelper.getTableInfo(clazz);
        try (Connection connection = SQLRunner.getConnection();){
            DatabaseMetaData dbMetaData = connection.getMetaData();
            ResultSet nowTable = dbMetaData.getTables(databaseName, databaseName, table.tableName, new String[]{"TABLE"});
            if (nowTable.next()) {
                ResultSet nowColumns = dbMetaData.getColumns(databaseName, databaseName, nowTable.getString("TABLE_NAME"), null);
                ArrayList<String> stringArrayList = new ArrayList<String>();
                while (nowColumns.next()) {
                    stringArrayList.add(nowColumns.getString("COLUMN_NAME"));
                }
                List nonExistentFields = Stream.of(table.allFields).filter(field -> !stringArrayList.contains(CaseUtils.toSnake((String)field.getName()))).collect(Collectors.toList());
                if (nonExistentFields.size() == 0) {
                    FixTableResult fixTableResult = FixTableResult.NO_NEED_TO_FIX;
                    return fixTableResult;
                }
                String columns = nonExistentFields.stream().map(field -> CaseUtils.toSnake((String)field.getName())).collect(Collectors.joining(" , ", " [ ", " ] "));
                Ansi.out().brightBlue((Object)("\u672a\u627e\u5230\u8868 " + table.tableName + " \u4e2d\u7684 " + columns + " \u5b57\u6bb5 --> \u6b63\u5728\u81ea\u52a8\u5efa\u7acb !!!")).println();
                String addSql = nonExistentFields.stream().map(field -> " ADD " + FixTableUtils.getSQLColumn(field)).collect(Collectors.joining(",", "", ""));
                String alertSql = "ALTER TABLE `" + table.tableName + "` " + addSql;
                List<String> otherSQLByField = FixTableUtils.getOtherSQL((Field[])nonExistentFields.toArray(Field[]::new));
                alertSql = otherSQLByField.size() > 0 ? alertSql + otherSQLByField.stream().map(str -> " ADD " + str).collect(Collectors.joining(",", ",", ";")) : alertSql + ";";
                SQLRunner.execute((String)alertSql, null);
                FixTableResult fixTableResult = FixTableResult.FIX_SUCCESS;
                return fixTableResult;
            }
            logger.warn("\u672a\u627e\u5230\u8868 {} --> \u6b63\u5728\u81ea\u52a8\u5efa\u7acb !!!", (Object)table.tableName);
            String createTableSql = "CREATE TABLE `" + table.tableName + "` ( " + Stream.of(table.allFields).map(field -> FixTableUtils.getSQLColumn(field) + ",").collect(Collectors.joining("", "", "")) + String.join((CharSequence)",", FixTableUtils.getOtherSQL(table.allFields)) + ") ;";
            SQLRunner.execute((String)createTableSql, null);
            FixTableResult fixTableResult = FixTableResult.FIX_SUCCESS;
            return fixTableResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return FixTableResult.FIX_FAIL;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean needFixTable(Class<?> clazz) {
        TableInfo table = SQLHelper.getTableInfo(clazz);
        try (Connection connection = SQLRunner.getConnection();){
            DatabaseMetaData dbMetaData = connection.getMetaData();
            ResultSet nowTable = dbMetaData.getTables(databaseName, databaseName, table.tableName, new String[]{"TABLE"});
            if (nowTable.next()) {
                ResultSet nowColumns = dbMetaData.getColumns(databaseName, databaseName, nowTable.getString("TABLE_NAME"), null);
                ArrayList<String> stringArrayList = new ArrayList<String>();
                while (nowColumns.next()) {
                    stringArrayList.add(nowColumns.getString("COLUMN_NAME"));
                }
                List nonExistentFields = Stream.of(table.allFields).filter(field -> !stringArrayList.contains(CaseUtils.toSnake((String)field.getName()))).collect(Collectors.toList());
                boolean bl2 = nonExistentFields.size() != 0;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static List<String> getOtherSQL(Field ... allFields) {
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : allFields) {
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            String columnName = CaseUtils.toSnake((String)field.getName());
            if (column.primaryKey()) {
                list.add("PRIMARY KEY (`" + columnName + "`)");
            }
            if (column.unique()) {
                list.add("UNIQUE KEY `unique_" + columnName + "`(`" + columnName + "`)");
            }
            if (!column.needIndex()) continue;
            list.add("KEY `index_" + columnName + "`(`" + columnName + "`)");
        }
        return list;
    }

    private static String getSQLColumn(Field field) {
        String columnName = "`" + CaseUtils.toSnake((String)field.getName()) + "` ";
        String type = "";
        String notNull = "";
        String autoIncrement = "";
        Object defaultValue = "";
        Object onUpdate = "";
        Column fieldColumn = field.getAnnotation(Column.class);
        if (fieldColumn != null) {
            type = "".equals(fieldColumn.type()) ? SQLHelper.getMySQLTypeCreateName(field.getType()) : fieldColumn.type();
            String string = notNull = fieldColumn.notNull() ? " NOT NULL" : " NULL";
            if (fieldColumn.autoIncrement()) {
                autoIncrement = " AUTO_INCREMENT ";
            }
            if (fieldColumn.primaryKey()) {
                notNull = " NOT NULL ";
            }
            if (!"".equals(fieldColumn.defaultValue())) {
                defaultValue = " DEFAULT " + fieldColumn.defaultValue();
            }
            if (!"".equals(fieldColumn.onUpdateValue())) {
                onUpdate = (String)onUpdate + " ON UPDATE " + fieldColumn.defaultValue();
            }
        } else {
            type = SQLHelper.getMySQLTypeCreateName(field.getType());
            notNull = " NULL ";
        }
        return columnName + type + notNull + autoIncrement + (String)defaultValue + (String)onUpdate;
    }
}

