package cool.scx.ext.cms;

import cool.scx.BaseModule;
import cool.scx.ScxContext;
import cool.scx.ScxTemplate;
import cool.scx.ext.cms.channel.ChannelListDirective;
import cool.scx.ext.cms.content.ContentListDirective;
import cool.scx.ext.cms.web_site.WebSiteHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * cms 模块 提供一些简单的 指令
 *
 * @author scx567888
 * @version 1.1.11
 */
public class CMSModule implements BaseModule {

    private final List<Class<? extends WebSiteHandler>> webSiteHandlerList = new ArrayList<>();


    /**
     * <p>Constructor for CmsModule.</p>
     */
    public CMSModule() {

    }

    /**
     * <p>Constructor for CmsModule.</p>
     *
     * @param webSiteHandlers a {@link java.lang.Class} object
     */
    public CMSModule(Class<? extends WebSiteHandler> webSiteHandlers) {
        webSiteHandlerList.add(webSiteHandlers);
    }

    /**
     * <p>Constructor for CmsModule.</p>
     *
     * @param webSiteHandlers a {@link java.util.List} object
     */
    public CMSModule(List<Class<? extends WebSiteHandler>> webSiteHandlers) {
        webSiteHandlerList.addAll(webSiteHandlers);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void start() {
        ScxTemplate.addDirective(ContentListDirective.class);
        ScxTemplate.addDirective(ChannelListDirective.class);
    }

    /**
     * 获取 列表
     *
     * @return r
     */
    public List<WebSiteHandler> webSiteHandlerList() {
        return webSiteHandlerList.stream().map(ScxContext::getBean).collect(Collectors.toList());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String name() {
        return "SCX-CMSModule";
    }

}
