/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.template;

import cool.scx.ScxEasyConfig;
import cool.scx.annotation.ScxMapping;
import cool.scx.bo.FileUpload;
import cool.scx.enumeration.Method;
import cool.scx.ext.cms.template.TemplateInfo;
import cool.scx.util.FileUtils;
import cool.scx.vo.Json;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

@ScxMapping
public class TemplateController {
    private static List<TemplateInfo> getTemplateList(String filePath) throws IOException {
        final LinkedList<TemplateInfo> fileList = new LinkedList<TemplateInfo>();
        final Path path = Paths.get(filePath, new String[0]);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                TemplateInfo fileInfo = new TemplateInfo();
                fileInfo.type = "Directory";
                TemplateController.getFileVisitResult(dir, fileInfo, path, fileList);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                TemplateInfo fileInfo = new TemplateInfo();
                fileInfo.type = "File";
                TemplateController.getFileVisitResult(file, fileInfo, path, fileList);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    private static void getFileVisitResult(Path file, TemplateInfo templateInfo, Path path, LinkedList<TemplateInfo> fileList) {
        templateInfo.id = file.getFileName().toString();
        templateInfo.parentId = file.getParent().toFile().getPath();
        templateInfo.parentId = path.toString().equals(templateInfo.parentId) ? "0" : file.getParent().getFileName().toString();
        templateInfo.filePath = file.toFile().getPath();
        fileList.add(templateInfo);
    }

    private static boolean checkPath(String path) {
        return path.startsWith(ScxEasyConfig.templateRoot().getPath());
    }

    @ScxMapping(method={Method.GET, Method.POST})
    public Json index() throws IOException {
        List<TemplateInfo> allTemplateList = TemplateController.getTemplateList(ScxEasyConfig.templateRoot().getPath());
        List directoryList = allTemplateList.stream().filter(templateInfo -> "Directory".equals(templateInfo.type)).collect(Collectors.toList());
        List fileList = allTemplateList.stream().filter(templateInfo -> "File".equals(templateInfo.type)).collect(Collectors.toList());
        directoryList.addAll(fileList);
        return Json.ok().put("cmsRootTreeList", directoryList);
    }

    @ScxMapping(method={Method.POST})
    public Json getFileContent(String filePath) {
        try {
            boolean b = TemplateController.checkPath(filePath);
            if (b) {
                String fileContent = Files.readString(Paths.get(filePath, new String[0]));
                return Json.ok().put("fileContent", (Object)fileContent);
            }
            return Json.ok().put("fileContent", (Object)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
        }
        catch (Exception exception) {
            return Json.ok().put("fileContent", (Object)"\u6b64\u6587\u4ef6\u65e0\u6cd5\u7f16\u8f91");
        }
    }

    @ScxMapping
    public Json setFileContent(String filePath, String fileContent) {
        boolean b = TemplateController.checkPath(filePath);
        if (b) {
            FileUtils.setFileContent((String)filePath, (String)fileContent);
            return this.getFileContent(filePath);
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }

    @ScxMapping
    public Json delete(String filePath) throws IOException {
        boolean b = TemplateController.checkPath(filePath);
        if (b) {
            Path file = Paths.get(filePath, new String[0]);
            FileUtils.deleteIfExists((Path)file);
            return Json.ok();
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }

    @ScxMapping
    public Json upload(FileUpload file, String filePath) {
        if (TemplateController.checkPath(filePath)) {
            FileUtils.fileAppend((Path)Path.of(filePath, file.fileName), (byte[])file.buffer.getBytes());
            return Json.ok();
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }

    @ScxMapping
    public Json rename(String newFilePath, String oldFilePath) {
        boolean b = TemplateController.checkPath(newFilePath);
        boolean b1 = TemplateController.checkPath(oldFilePath);
        if (b && b1) {
            Path path = Paths.get(oldFilePath, new String[0]);
            String parent = path.getParent().toFile().getPath();
            boolean b2 = path.toFile().renameTo(new File(parent + "\\" + newFilePath));
            return b2 ? Json.ok() : Json.fail();
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }
}

