package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.bo.Where;
import cool.scx.enumeration.WhereType;
import cool.scx.util.StringUtils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>CoreDeptService class.</p>
 *
 * @author scx567888
 * @version 1.1.2
 */
@ScxService
public class DeptService extends BaseService<Dept> {

    private final UserDeptService userDeptService;

    /**
     * <p>Constructor for CoreDeptService.</p>
     *
     * @param userDeptService a {@link cool.scx.ext.organization.UserDeptService} object.
     */
    public DeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    /**
     * getDeptListByUser
     *
     * @param user a {@link cool.scx.ext.organization.User} object
     * @return a {@link java.util.List} object
     */
    public List<Dept> getDeptListByUser(User user) {
        try {
            var roleIds = userDeptService.list(new Query().equal("userId", user.id))
                    .stream().map(userRole -> userRole.deptId).collect(Collectors.toList());
            return list(new Query().in("id", roleIds));
        } catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<>();
        }
    }

    /**
     * saveDeptListWithUserId
     *
     * @param userId  a {@link java.lang.Long} object
     * @param deptIds a {@link java.lang.String} object
     * @throws SQLException s
     */
    public void saveDeptListWithUserId(Long userId, List<Long> deptIds) throws SQLException {
        if (!StringUtils.isEmpty(deptIds)) {
            var idArr = deptIds.stream().filter(id -> !StringUtils.isEmpty(id)).map(id -> {
                        var userDept = new UserDept();
                        userDept.userId = userId;
                        userDept.deptId = id;
                        return userDept;
                    }
            ).collect(Collectors.toList());
            userDeptService.save(idArr);
        }
    }

    /**
     * {@inheritDoc}
     *
     * @param id a {@link java.lang.Long} object
     */
    public void deleteByUserId(Long id) throws SQLException {
        var where = new Where("userId", WhereType.EQUAL, id);
        userDeptService.delete(where);
    }

    /**
     * {@inheritDoc}
     *
     * @param userId a {@link java.lang.Long} object
     * @return a {@link java.util.List} object
     */
    public List<UserDept> findDeptByUserId(Long userId) throws SQLException {
        if (StringUtils.isNotEmpty(userId)) {
            var queryParam = new Query().addWhere("userId", WhereType.EQUAL, userId);
            return userDeptService.list(queryParam);
        }
        return new ArrayList<>();
    }

    /**
     * <p>getUserDeptByUserIds.</p>
     *
     * @param userIds a {@link java.util.List} object
     * @return a {@link java.util.List} object
     */
    public List<UserDept> getUserDeptByUserIds(List<Long> userIds) {
        try {
            return userDeptService.list(new Query().in("userId", userIds));
        } catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<>();
        }
    }
}
