/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.ScxContext;
import cool.scx.ScxEasyConfig;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.ScxMapping;
import cool.scx.bo.Query;
import cool.scx.bo.Where;
import cool.scx.enumeration.Method;
import cool.scx.exception.UnauthorizedException;
import cool.scx.ext.organization.OrganizationConfig;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserService;
import cool.scx.ext.organization.auth.OrganizationAuth;
import cool.scx.ext.organization.auth.OrganizationAuthDeviceType;
import cool.scx.ext.organization.auth.OrganizationLoginException;
import cool.scx.ext.organization.auth.UnknownDeviceException;
import cool.scx.ext.organization.auth.UnknownUserException;
import cool.scx.ext.organization.auth.WrongPasswordException;
import cool.scx.util.Ansi;
import cool.scx.util.CryptoUtils;
import cool.scx.util.NetUtils;
import cool.scx.util.StringUtils;
import cool.scx.vo.Json;
import io.vertx.ext.web.RoutingContext;
import java.sql.SQLException;
import java.time.LocalDateTime;

@ScxMapping(value="/api/auth")
public class OrganizationAuthController {
    private final UserService userService;

    public OrganizationAuthController(UserService userService) {
        this.userService = userService;
    }

    @ScxMapping(method={Method.POST})
    public Json login(@FromBody String username, @FromBody String password, RoutingContext ctx) throws SQLException {
        try {
            OrganizationAuthDeviceType loginDevice = OrganizationAuth.getDeviceTypeByHeader(ctx);
            String token = this.tryGetAuthToken(ctx, loginDevice);
            User loginUser = this.tryLogin(username, password);
            OrganizationAuth.addLoginItem(token, loginUser, loginDevice);
            this.updateLastLoginDateAndIP(loginUser.username);
            if (loginDevice == OrganizationAuthDeviceType.WEBSITE) {
                return Json.fail((String)"login-successful");
            }
            return Json.ok().put("token", (Object)token);
        }
        catch (OrganizationLoginException organizationLoginException) {
            if (organizationLoginException instanceof UnknownDeviceException) {
                return Json.fail((String)"\u672a\u77e5\u8bbe\u5907");
            }
            if (organizationLoginException instanceof UnknownUserException) {
                return Json.fail((String)(OrganizationConfig.confusionLoginError() ? "usernameOrPasswordError" : "userNotFound"));
            }
            if (organizationLoginException instanceof WrongPasswordException) {
                return Json.fail((String)(OrganizationConfig.confusionLoginError() ? "usernameOrPasswordError" : "passwordError"));
            }
            System.err.println("\u767b\u5f55\u51fa\u9519 : " + organizationLoginException.getMessage());
            return Json.fail((String)"logonFailure");
        }
    }

    @ScxMapping(method={Method.POST})
    public Json signup(String username, String password) throws SQLException {
        if (this.userService.get(new Query().equal("username", (Object)username)) != null) {
            return Json.fail((String)"userAlreadyExists");
        }
        User user = new User();
        user.username = username;
        user.password = CryptoUtils.encryptPassword((String)password);
        user.isAdmin = false;
        return this.userService.save(user) != null ? Json.ok() : Json.fail((String)"signup-error");
    }

    @ScxMapping(method={Method.POST})
    public Json logout() {
        boolean b = OrganizationAuth.removeAuthUser(ScxContext.routingContext());
        System.err.println("\u5f53\u524d\u603b\u767b\u5f55\u7528\u6237\u6570\u91cf : " + OrganizationAuth.getAllLoginItem().size() + " \u4e2a");
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(method={Method.GET})
    public Json info() throws UnauthorizedException {
        User user = OrganizationAuth.getLoginUser(ScxContext.routingContext());
        if (user == null) {
            throw new UnauthorizedException();
        }
        return Json.ok().put("id", (Object)user.id).put("username", (Object)user.username).put("nickname", (Object)user.nickname).put("avatar", (Object)user.avatar).put("perms", OrganizationAuth.getPerms(user)).put("tombstone", (Object)ScxEasyConfig.tombstone());
    }

    @ScxMapping(method={Method.PUT})
    public Json infoUpdate(User newUserInfo) throws SQLException {
        User currentUser = OrganizationAuth.getLoginUser(ScxContext.routingContext());
        String string = currentUser.password = StringUtils.isEmpty((Object)newUserInfo.password) ? null : CryptoUtils.encryptPassword((String)newUserInfo.password);
        if (this.userService.update(currentUser) != null) {
            Ansi.out().color((Object)("\u66f4\u65b0\u4e86\u81ea\u5df1\u7684\u4fe1\u606f \u7528\u6237\u540d\u662f :" + currentUser.username)).println();
            return Json.ok();
        }
        return Json.fail();
    }

    private User tryLogin(String username, String password) throws OrganizationLoginException, SQLException {
        User user = (User)this.userService.get(new Query().equal("username", (Object)username));
        if (user == null) {
            throw new UnknownUserException();
        }
        if (!CryptoUtils.checkPassword((String)password, (String)user.password)) {
            throw new WrongPasswordException();
        }
        return user;
    }

    private String tryGetAuthToken(RoutingContext ctx, OrganizationAuthDeviceType loginDevice) throws OrganizationLoginException {
        switch (loginDevice) {
            case ADMIN: 
            case ANDROID: 
            case APPLE: {
                return StringUtils.getUUID();
            }
            case WEBSITE: {
                return OrganizationAuth.getTokenByCookie(ctx);
            }
        }
        throw new UnknownDeviceException();
    }

    private void updateLastLoginDateAndIP(String username) throws SQLException {
        User oldUser = (User)this.userService.get(new Query().equal("username", (Object)username));
        oldUser.lastLoginDateList.add(LocalDateTime.now());
        oldUser.lastLoginIPList.add(NetUtils.getIpAddr());
        User tempUser = new User();
        tempUser.lastLoginDateList = oldUser.lastLoginDateList.subList(Math.max(oldUser.lastLoginDateList.size() - 10, 0), oldUser.lastLoginDateList.size());
        tempUser.lastLoginIPList = oldUser.lastLoginIPList.subList(Math.max(oldUser.lastLoginIPList.size() - 10, 0), oldUser.lastLoginIPList.size());
        this.userService.update(tempUser, new Where().equal("username", (Object)username));
    }
}

