/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.util.ObjectUtils;
import io.vertx.core.http.ServerWebSocket;

public class WSBody {
    private final Body body;
    private final ServerWebSocket webSocket;

    public WSBody(String eventName, JsonNode data, ServerWebSocket webSocket) {
        this.body = new Body(eventName, data);
        this.webSocket = webSocket;
    }

    public WSBody(String eventName, Object data, ServerWebSocket webSocket) {
        this.body = new Body(eventName, ObjectUtils.valueToTreeUseAnnotations((Object)data));
        this.webSocket = webSocket;
    }

    public JsonNode data() {
        return this.body.data;
    }

    public String eventName() {
        return this.body.eventName;
    }

    public String toJson() {
        return ObjectUtils.writeValueAsStringUseAnnotations((Object)this.body, (String)"");
    }

    public ServerWebSocket webSocket() {
        return this.webSocket;
    }

    private static class Body {
        public final String eventName;
        public final JsonNode data;

        public Body(String eventName, JsonNode data) {
            this.eventName = eventName;
            this.data = data;
        }
    }
}

