/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import cool.scx.ext.core.CoreOnlineItem;
import io.vertx.core.http.ServerWebSocket;
import java.util.ArrayList;
import java.util.List;

public class CoreOnlineItemHandler {
    private static final List<CoreOnlineItem> ONLINE_ITEMS = new ArrayList<CoreOnlineItem>();

    public static void addOnlineItem(ServerWebSocket webSocket, String username) {
        String binaryHandlerID = webSocket.binaryHandlerID();
        CoreOnlineItem onlineItem = ONLINE_ITEMS.stream().filter(u -> u.webSocket.binaryHandlerID().equals(binaryHandlerID)).findAny().orElse(null);
        if (onlineItem == null) {
            CoreOnlineItem newOnlineItem = new CoreOnlineItem(webSocket, username);
            ONLINE_ITEMS.add(newOnlineItem);
        } else {
            onlineItem.username = username;
        }
    }

    public static boolean removeOnlineItemByWebSocket(ServerWebSocket webSocket) {
        return ONLINE_ITEMS.removeIf(f -> f.webSocket.binaryHandlerID().equals(webSocket.binaryHandlerID()));
    }

    public static long getOnlineUserCount() {
        return ONLINE_ITEMS.stream().filter(u -> u.username != null).count();
    }

    public static CoreOnlineItem getOnlineItemByWebSocket(ServerWebSocket webSocket) {
        String binaryHandlerID = webSocket.binaryHandlerID();
        return ONLINE_ITEMS.stream().filter(u -> u.webSocket.binaryHandlerID().equals(binaryHandlerID)).findAny().orElse(null);
    }

    public static CoreOnlineItem getOnlineItemByUserName(String username) {
        return ONLINE_ITEMS.stream().filter(u -> u.username.equals(username)).findAny().orElse(null);
    }

    public static List<CoreOnlineItem> getOnlineItemList() {
        return ONLINE_ITEMS;
    }
}

