/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.message;

import cool.scx.ScxConfig;
import cool.scx.annotation.ScxService;
import cool.scx.util.CryptoUtils;
import cool.scx.util.DigestUtils;
import cool.scx.util.HttpUtils;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ScxService
public class YTXTextMessageSender {
    private static final String YTX_BASE_URL = "https://app.cloopen.com:8883";
    private final String YTX_ACCOUNT_SID;
    private final String YTX_AUTH_TOKEN;
    private final String YTX_APP_ID;
    private final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public YTXTextMessageSender() {
        this.YTX_ACCOUNT_SID = (String)ScxConfig.get((String)"message.ytx-account-sid", String.class);
        this.YTX_AUTH_TOKEN = (String)ScxConfig.get((String)"message.ytx-auth-token", String.class);
        this.YTX_APP_ID = (String)ScxConfig.get((String)"message.ytx-app-id", String.class);
    }

    public String send(List<String> address, Map<String, Object> message) throws IOException, InterruptedException {
        String timeStampStr = this.getTimeStampStr();
        String authorization = this.getAuthorization(timeStampStr);
        String sigParameter = this.getSigParameter(timeStampStr);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("to", address.stream().collect(Collectors.joining(",", "", "")));
        map.put("appId", this.YTX_APP_ID);
        map.put("templateId", message.get("templateId"));
        map.put("datas", message.get("datas"));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", authorization);
        HttpResponse post = HttpUtils.post((String)this.getSendUrl(sigParameter), header, map);
        return (String)post.body();
    }

    private String getSendUrl(String sigParameter) {
        String s = "/2013-12-26/Accounts/" + this.YTX_ACCOUNT_SID + "/SMS/TemplateSMS?sig=" + sigParameter;
        return YTX_BASE_URL + s;
    }

    private String getSigParameter(String TimeStampStr) {
        return DigestUtils.md5((String)(this.YTX_ACCOUNT_SID + this.YTX_AUTH_TOKEN + TimeStampStr));
    }

    private String getAuthorization(String TimeStampStr) {
        return CryptoUtils.encodeBase64((String)(this.YTX_ACCOUNT_SID + ":" + TimeStampStr));
    }

    private String getTimeStampStr() {
        return LocalDateTime.now().format(this.DATETIME_FORMAT);
    }
}

