package cool.scx.ext;

import cool.scx.ScxApp;
import cool.scx.ext.cms.CMSModule;
import cool.scx.ext.core.CoreModule;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.fixtable.FixTableModule;
import cool.scx.ext.fss.FSSModule;
import cool.scx.ext.message.MessageModule;
import cool.scx.ext.office.OfficeModule;
import cool.scx.ext.organization.OrganizationModule;

/**
 * 运行所有核心包提供的模块 (演示用,不要用于生产环境)
 *
 * @author scx567888
 * @version 1.1.11
 */
public class AllExtApp {

    /**
     * 核心启动方法
     *
     * @param args 外部参数
     */
    public static void main(String[] args) {
        ScxApp.builder()
                .setMainClass(AllExtApp.class)
                .addModules(
                        new CMSModule(),
                        new CoreModule(),
                        new CRUDModule(),
                        new FixTableModule(),
                        new FSSModule(),
                        new MessageModule(),
                        new OfficeModule(),
                        new OrganizationModule())
                .setArgs(args)
                .build().run();
    }

}
