/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.bo.Where;
import cool.scx.enumeration.WhereType;
import cool.scx.ext.organization.Dept;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserDept;
import cool.scx.ext.organization.UserDeptService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ScxService
public class DeptService
extends BaseService<Dept> {
    private final UserDeptService userDeptService;

    public DeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    public List<Dept> getDeptListByUser(User user) {
        try {
            List roleIds = this.userDeptService.list(new Query().equal("userId", (Object)user.id)).stream().map(userRole -> userRole.deptId).collect(Collectors.toList());
            return this.list(new Query().in("id", roleIds));
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<Dept>();
        }
    }

    public void saveDeptListWithUserId(Long userId, List<Long> deptIds) throws SQLException {
        if (deptIds != null) {
            List idArr = deptIds.stream().filter(Objects::nonNull).map(id -> {
                UserDept userDept = new UserDept();
                userDept.userId = userId;
                userDept.deptId = id;
                return userDept;
            }).collect(Collectors.toList());
            this.userDeptService.save(idArr);
        }
    }

    public void deleteByUserId(Long id) throws SQLException {
        Where where = new Where("userId", WhereType.EQUAL, (Object)id);
        this.userDeptService.delete(where);
    }

    public List<UserDept> findDeptByUserId(Long userId) throws SQLException {
        if (userId != null) {
            Query queryParam = new Query().addWhere("userId", WhereType.EQUAL, (Object)userId);
            return this.userDeptService.list(queryParam);
        }
        return new ArrayList<UserDept>();
    }

    public List<UserDept> getUserDeptByUserIds(List<Long> userIds) {
        try {
            return this.userDeptService.list(new Query().in("userId", userIds));
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<UserDept>();
        }
    }
}

