/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.ext.organization.DeptService;
import cool.scx.ext.organization.RoleService;
import cool.scx.ext.organization.User;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@ScxService
public class UserService
extends BaseService<User> {
    private final DeptService deptService;
    private final RoleService roleService;

    public UserService(DeptService deptService, RoleService roleService) {
        this.deptService = deptService;
        this.roleService = roleService;
    }

    public User getByUsername(String uniqueID) throws SQLException {
        return (User)this.get(new Query().equal("username", (Object)uniqueID));
    }

    public List<User> listWithRoleAndDept(Query query) throws SQLException {
        List userList = super.list(query);
        List userIds = userList.stream().map(user -> user.id).collect(Collectors.toList());
        CompletableFuture<List> userDeptListFuture = CompletableFuture.supplyAsync(() -> this.deptService.getUserDeptByUserIds(userIds));
        CompletableFuture<List> userRoleListFuture = CompletableFuture.supplyAsync(() -> this.roleService.getUserRoleByUserIds(userIds));
        try {
            List userDeptList = userDeptListFuture.get();
            List userRoleList = userRoleListFuture.get();
            return userList.stream().peek(item -> {
                item.deptIds = userDeptList.stream().filter(userDept -> userDept.userId.equals(item.id)).map(deptItem -> deptItem.deptId).collect(Collectors.toList());
                item.roleIds = userRoleList.stream().filter(userRole -> userRole.userId.equals(item.id)).map(deptItem -> deptItem.roleId).collect(Collectors.toList());
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

