/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.Scx;
import cool.scx.ScxModuleInfo;
import cool.scx.annotation.NoColumn;
import cool.scx.annotation.ScxModel;
import cool.scx.annotation.ScxService;
import cool.scx.base.BaseModel;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.enumeration.WhereType;
import cool.scx.exception.BadRequestException;
import cool.scx.exception.CustomHttpRequestException;
import cool.scx.exception.HttpRequestException;
import cool.scx.ext.crud.CrudWhereBody;
import cool.scx.util.Ansi;
import cool.scx.util.ObjectUtils;
import cool.scx.vo.Json;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class CRUDHelper {
    private static final Map<String, Class<?>> SCX_BEAN_CLASS_NAME_MAPPING = new HashMap();

    public static <T extends BaseModel> BaseService<T> getBaseService(String modelName) throws HttpRequestException {
        try {
            Object o = Scx.context().getBean(CRUDHelper.getClassByName(modelName.toLowerCase() + "service"));
            return (BaseService)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-crud-service").put("service-name", (Object)modelName.toLowerCase()).sendToClient(ctx));
        }
    }

    public static BaseModel getBaseModel(Map<String, Object> entityMap, String modelName) throws HttpRequestException {
        try {
            return (BaseModel)ObjectUtils.convertValue(entityMap, CRUDHelper.getClassByName(modelName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException((Throwable)e);
        }
    }

    public static Class<?> getClassByName(String str) {
        return SCX_BEAN_CLASS_NAME_MAPPING.get(str.toLowerCase());
    }

    public static Query getQuery(Class<?> modelClass, Integer limit, Integer page, String orderByColumn, String sortType, List<CrudWhereBody> whereBodyList) throws CustomHttpRequestException {
        Query query = new Query();
        if (limit != null && limit >= 0) {
            if (page != null && page >= 0) {
                query.setPagination(page, limit);
            } else {
                query.setPagination(limit);
            }
        }
        if (orderByColumn != null && sortType != null) {
            query.addOrderBy(orderByColumn, sortType);
        }
        if (whereBodyList != null) {
            for (CrudWhereBody crudWhereBody : whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDHelper.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDHelper.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    query.addWhere(crudWhereBody.fieldName, whereType);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    query.addWhere(crudWhereBody.fieldName, whereType, crudWhereBody.value1);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                query.addWhere(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
            }
        }
        return query;
    }

    public static void checkFieldName(Class<?> modelClass, String fieldName) throws CustomHttpRequestException {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-field-name").put("field-name", (Object)fieldName).sendToClient(ctx));
            }
        }
        catch (Exception e) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-field-name").put("field-name", (Object)fieldName).sendToClient(ctx));
        }
    }

    public static WhereType checkWhereType(String fieldName, String strWhereType) throws CustomHttpRequestException {
        try {
            return WhereType.valueOf((String)strWhereType.toUpperCase());
        }
        catch (Exception ignored) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"unknown-where-type").put("field-name", (Object)fieldName).put("where-type", (Object)strWhereType).sendToClient(ctx));
        }
    }

    public static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws CustomHttpRequestException {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new CustomHttpRequestException(ctx -> Json.fail((String)"where-body-parameters-size-error").put("field-name", (Object)fieldName).put("where-type", (Object)whereType).put("need-parameters-size", (Object)whereType.paramSize()).put("got-parameters-size", (Object)paramSize.get()).sendToClient(ctx));
        }
    }

    static {
        for (ScxModuleInfo allModule : Scx.scxModuleInfos()) {
            for (Class c : allModule.classList()) {
                if (!c.isAnnotationPresent(ScxService.class) && !c.isAnnotationPresent(ScxModel.class)) continue;
                String className = c.getSimpleName().toLowerCase();
                Class<?> aClass = SCX_BEAN_CLASS_NAME_MAPPING.get(className);
                if (aClass == null) {
                    SCX_BEAN_CLASS_NAME_MAPPING.put(c.getSimpleName().toLowerCase(), c);
                    continue;
                }
                SCX_BEAN_CLASS_NAME_MAPPING.put(c.getName(), c);
                Ansi.out().brightRed((Object)"\u68c0\u6d4b\u5230\u91cd\u590d\u540d\u79f0\u7684 class ").brightYellow((Object)("[" + aClass.getName() + "] ")).blue((Object)("[" + c.getName() + "]")).brightRed((Object)" \u53ef\u80fd\u4f1a\u5bfc\u81f4\u6839\u636e\u540d\u79f0\u8c03\u7528\u65f6\u610f\u4e49\u4e0d\u660e\u786e !!! \u5efa\u8bae\u4fee\u6539 !!!").println();
            }
        }
    }
}

