/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.Scx;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.FromPath;
import cool.scx.annotation.ScxMapping;
import cool.scx.base.BaseModel;
import cool.scx.enumeration.Method;
import cool.scx.exception.HttpRequestException;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.crud.CrudWhereBody;
import cool.scx.vo.Json;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@ScxMapping(value="api/crud")
public class CRUDController {
    private final CRUDHandler crudHandler;

    public CRUDController() {
        Class<? extends CRUDHandler> crudHandlerClass = ((CRUDModule)Scx.findScxModuleInfo(CRUDModule.class).baseModuleExample()).crudHandlerClass();
        this.crudHandler = (CRUDHandler)Scx.context().getBean(crudHandlerClass);
    }

    @ScxMapping(value=":modelName/list", method={Method.POST})
    public Json list(@FromPath String modelName, @FromBody(value="pagination.limit", required=false) Integer limit, @FromBody(value="pagination.page", required=false) Integer page, @FromBody(value="orderBy.orderByColumn", required=false) String orderByColumn, @FromBody(value="orderBy.sortType", required=false) String sortType, @FromBody(value="whereBodyList", required=false) List<CrudWhereBody> whereBodyList) throws HttpRequestException, SQLException {
        CRUDListResult crudListResult = this.crudHandler.list(modelName, limit, page, orderByColumn, sortType, whereBodyList);
        return Json.ok().put("items", crudListResult.list()).put("total", (Object)crudListResult.total());
    }

    @ScxMapping(value=":modelName/:id", method={Method.GET})
    public Json info(@FromPath String modelName, @FromBody Long id) throws HttpRequestException, SQLException {
        BaseModel info = this.crudHandler.info(modelName, id);
        return Json.ok().put("info", (Object)info);
    }

    @ScxMapping(value=":modelName", method={Method.POST})
    public Json save(@FromPath String modelName, @FromBody(useKeyPath=false) Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        BaseModel savedModel = this.crudHandler.save(modelName, entityMap);
        return Json.ok().put("item", (Object)savedModel);
    }

    @ScxMapping(value=":modelName", method={Method.PUT})
    public Json update(@FromPath String modelName, @FromBody(useKeyPath=false) Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        BaseModel updatedModel = this.crudHandler.update(modelName, entityMap);
        return Json.ok().put("item", (Object)updatedModel);
    }

    @ScxMapping(value=":modelName/:id", method={Method.DELETE})
    public Json delete(@FromPath String modelName, @FromBody Long id) throws HttpRequestException, SQLException {
        boolean b = this.crudHandler.delete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/batch-delete", method={Method.DELETE})
    public Json batchDelete(@FromPath String modelName, @FromBody long[] deleteIds) throws HttpRequestException, SQLException {
        long deletedCount = this.crudHandler.batchDelete(modelName, deleteIds);
        return Json.ok().put("deletedCount", (Object)deletedCount);
    }

    @ScxMapping(value=":modelName/revoke-delete/:id", method={Method.GET})
    public Json revokeDelete(@FromPath String modelName, @FromBody Long id) throws HttpRequestException, SQLException {
        if (!Scx.easyConfig().tombstone()) {
            return Json.fail((String)"not-used-tombstone");
        }
        boolean b = this.crudHandler.revokeDelete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/get-auto-complete/:fieldName", method={Method.POST})
    public Json getAutoComplete(@FromPath String modelName, @FromBody String fieldName) throws HttpRequestException, SQLException {
        List<Map<String, Object>> fieldList = this.crudHandler.getAutoComplete(modelName, fieldName);
        return Json.ok().put("fields", fieldList);
    }

    @ScxMapping(value=":modelName/check-unique", method={Method.POST})
    public Json checkUnique(@FromPath String modelName, @FromBody String fieldName, @FromBody Object value, @FromBody(required=false) Long id) throws HttpRequestException, SQLException {
        boolean b = this.crudHandler.checkUnique(modelName, fieldName, value, id);
        return Json.ok().put("isUnique", (Object)b);
    }
}

