/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.Scx;
import cool.scx.annotation.ScxService;
import cool.scx.bo.FileUpload;
import cool.scx.bo.Query;
import cool.scx.exception.HttpRequestException;
import cool.scx.exception.NotFoundException;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSObject;
import cool.scx.ext.fss.FSSObjectService;
import cool.scx.util.DigestUtils;
import cool.scx.util.FileUtils;
import cool.scx.util.StringUtils;
import cool.scx.vo.Download;
import cool.scx.vo.Image;
import cool.scx.vo.Json;
import cool.scx.vo.Raw;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

@ScxService
public abstract class FSSHandler {
    private final FSSObjectService fssObjectService;

    public FSSHandler(FSSObjectService fssObjectService) {
        this.fssObjectService = fssObjectService;
    }

    public FSSHandler() {
        this.fssObjectService = (FSSObjectService)((Object)Scx.context().getBean(FSSObjectService.class));
    }

    public static String[] getNewFSSObjectPath(LocalDateTime uploadTime, String fssObjectId, String fileName) {
        return new String[]{String.valueOf(uploadTime.getYear()), String.valueOf(uploadTime.getMonthValue()), String.valueOf(uploadTime.getDayOfMonth()), fssObjectId, fileName};
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Integer getLastUploadChunk(File uploadConfigFile, Integer chunkLength) {
        try (FileReader fr = new FileReader(uploadConfigFile);){
            Integer n;
            try (BufferedReader br = new BufferedReader(fr);){
                n = Integer.parseInt(br.readLine().split("_")[0]);
            }
            return n;
        }
        catch (Exception e) {
            FSSHandler.updateLastUploadChunk(uploadConfigFile, -1, chunkLength);
            return -1;
        }
    }

    public static void updateLastUploadChunk(File uploadConfigFile, Integer nowChunkIndex, Integer chunkLength) {
        try {
            Files.createDirectories(Path.of(uploadConfigFile.getParent(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (FileWriter fw = new FileWriter(uploadConfigFile, false);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(nowChunkIndex + "_" + chunkLength);
            bw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static FSSObject getNewFSSObject(String fileName, Long fileSize, String fileMD5) {
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectId = StringUtils.getUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = LocalDateTime.now();
        fssObject.fileSizeDisplay = FileUtils.longToDisplaySize((long)fileSize);
        fssObject.fileSize = fileSize;
        fssObject.fileMD5 = fileMD5;
        fssObject.filePath = FSSHandler.getNewFSSObjectPath(fssObject.uploadTime, fssObject.fssObjectId, fssObject.fileName);
        return fssObject;
    }

    public FSSObject copyFSSObject(String fileName, FSSObject oldFSSObject) {
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectId = StringUtils.getUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = LocalDateTime.now();
        fssObject.filePath = oldFSSObject.filePath;
        fssObject.fileSizeDisplay = oldFSSObject.fileSizeDisplay;
        fssObject.fileSize = oldFSSObject.fileSize;
        fssObject.fileMD5 = oldFSSObject.fileMD5;
        return fssObject;
    }

    public FSSObject checkFSSObjectId(String fssObjectId) throws NotFoundException, SQLException {
        FSSObject fssObject = this.fssObjectService.findByFSSObjectId(fssObjectId);
        if (fssObject == null) {
            throw new NotFoundException();
        }
        return fssObject;
    }

    public File checkPhysicalFile(FSSObject fssObject) throws NotFoundException {
        File physicalFile = FSSObjectService.getPhysicalFilePath(fssObject).toFile();
        if (!physicalFile.exists()) {
            throw new NotFoundException();
        }
        return physicalFile;
    }

    public Download download(String fssObjectId) throws HttpRequestException, SQLException {
        FSSObject fssObject = this.checkFSSObjectId(fssObjectId);
        File file = this.checkPhysicalFile(fssObject);
        return new Download(file, fssObject.fileName);
    }

    public Image image(String fssObjectId, Integer width, Integer height, String type) throws HttpRequestException, SQLException {
        FSSObject fssObject = this.checkFSSObjectId(fssObjectId);
        File file = this.checkPhysicalFile(fssObject);
        return new Image(file, width, height, type);
    }

    public Raw raw(String fssObjectId) throws HttpRequestException, SQLException {
        FSSObject fssObject = this.checkFSSObjectId(fssObjectId);
        File file = this.checkPhysicalFile(fssObject);
        return new Raw(file);
    }

    public Json upload(String fileName, Long fileSize, String fileMD5, Integer chunkLength, Integer nowChunkIndex, FileUpload fileData) throws SQLException {
        Path uploadTempFile = Path.of(FSSConfig.uploadFilePath().getPath(), "TEMP", fileMD5 + "_" + fileName, ".SCXFSSTemp");
        File uploadConfigFile = Path.of(FSSConfig.uploadFilePath().getPath(), "TEMP", fileMD5 + "_" + fileName, ".SCXFSSUpload").toFile();
        if (nowChunkIndex == chunkLength - 1) {
            FileUtils.fileAppend((Path)uploadTempFile, (byte[])fileData.buffer.getBytes());
            FSSObject newFSSObject = FSSHandler.getNewFSSObject(fileName, fileSize, fileMD5);
            Path fileStoragePath = Path.of(FSSConfig.uploadFilePath().getPath(), newFSSObject.filePath);
            String serverMd5Str = DigestUtils.md5((File)uploadTempFile.toFile());
            if (!fileMD5.equalsIgnoreCase(serverMd5Str)) {
                FileUtils.deleteFiles((Path)uploadTempFile.getParent());
                return Json.fail((String)"upload-fail");
            }
            boolean renameSuccess = FileUtils.fileMove((Path)uploadTempFile, (Path)fileStoragePath);
            if (renameSuccess) {
                FileUtils.deleteFiles((Path)uploadTempFile.getParent());
                FSSObject save = (FSSObject)this.fssObjectService.save(newFSSObject);
                return Json.ok().put("type", (Object)"upload-success").put("item", (Object)save);
            }
            return Json.fail((String)"upload-fail");
        }
        Integer lastUploadChunk = FSSHandler.getLastUploadChunk(uploadConfigFile, chunkLength);
        int needUploadChunkIndex = lastUploadChunk + 1;
        if (nowChunkIndex.equals(needUploadChunkIndex)) {
            FileUtils.fileAppend((Path)uploadTempFile, (byte[])fileData.buffer.getBytes());
            FSSHandler.updateLastUploadChunk(uploadConfigFile, nowChunkIndex, chunkLength);
            return Json.ok().put("type", (Object)"need-more").put("item", (Object)(needUploadChunkIndex + 1));
        }
        return Json.ok().put("type", (Object)"need-more").put("item", (Object)needUploadChunkIndex);
    }

    public Json delete(String fssObjectIds) throws SQLException {
        FSSObject needDeleteFile = (FSSObject)this.fssObjectService.get(new Query().equal("fssObjectId", (Object)fssObjectIds));
        if (needDeleteFile != null) {
            Path filePath;
            long count = this.fssObjectService.count(new Query().equal("fileMD5", (Object)needDeleteFile.fileMD5));
            if (count <= 1L && Files.exists(filePath = Path.of(FSSConfig.uploadFilePath().getPath(), needDeleteFile.filePath), new LinkOption[0]) && !FileUtils.deleteFiles((Path)filePath.getParent())) {
                return Json.fail();
            }
            this.fssObjectService.delete(new long[]{needDeleteFile.id});
        }
        return Json.ok();
    }

    public Json list(List<String> fssObjectIds) throws SQLException {
        if (fssObjectIds != null && fssObjectIds.size() > 0) {
            return Json.ok().put("items", this.fssObjectService.findByFSSObjectIds(fssObjectIds));
        }
        return Json.ok().put("items", new ArrayList());
    }

    public Json checkAnyFileExistsByThisMD5(String fileName, Long fileSize, String fileMD5) throws SQLException {
        Path uploadTempFileParent = Path.of(FSSConfig.uploadFilePath().getPath(), "TEMP", fileMD5 + "_" + fileName, ".SCXFSSTemp").getParent();
        List<FSSObject> fssObjectListByMd5 = this.fssObjectService.findFSSObjectListByMd5(fileMD5);
        if (fssObjectListByMd5 != null && fssObjectListByMd5.size() > 0) {
            FSSObject canUseFssObject = null;
            for (FSSObject fssObject : fssObjectListByMd5) {
                File physicalFile = Path.of(FSSConfig.uploadFilePath().getPath(), fssObject.filePath).toFile();
                if (!physicalFile.exists() || physicalFile.length() != fileSize.longValue() || !fileMD5.equalsIgnoreCase(DigestUtils.md5((File)physicalFile))) continue;
                canUseFssObject = fssObject;
                break;
            }
            if (canUseFssObject != null) {
                FSSObject save = (FSSObject)this.fssObjectService.save(this.copyFSSObject(fileName, canUseFssObject));
                FileUtils.deleteFiles((Path)uploadTempFileParent);
                return Json.ok().put("type", (Object)"upload-by-md5-success").put("item", (Object)save);
            }
        }
        return Json.fail((String)"no-any-file-exists-for-this-md5");
    }
}

