package cool.scx.ext.cms;

import cool.scx.base.BaseTemplateDirective;
import cool.scx.ext.cms.directive.ChannelListDirective;
import cool.scx.ext.cms.directive.ContentListDirective;
import cool.scx.ext.cms.web_site.WebSiteHandler;
import cool.scx.ext.cms.web_site.WebSiteHandlerImpl;

import java.util.ArrayList;
import java.util.List;

/**
 * cms 模块配置文件
 */
public final class CMSModuleConfiguration {

    /**
     * 指令
     */
    private final List<Class<? extends BaseTemplateDirective>> userDirectiveList = new ArrayList<>();

    /**
     * WebSiteHandler 列表 访问页面时会按照顺序执行 一般用来向首页添加自定义的信息
     */
    private Class<? extends WebSiteHandler> webSiteHandlerClass = WebSiteHandlerImpl.class;

    /**
     * @return a
     */
    public Class<? extends WebSiteHandler> getWebSiteHandlerClass() {
        return webSiteHandlerClass;
    }

    /**
     * @param webSiteHandlerClass a
     */
    public void setWebSiteHandler(Class<? extends WebSiteHandler> webSiteHandlerClass) {
        this.webSiteHandlerClass = webSiteHandlerClass;
    }

    /**
     * 获取默认指令
     *
     * @return r
     */
    public CMSModuleConfiguration addUserDirective(Class<? extends BaseTemplateDirective> userDirectiveClass) {
        this.userDirectiveList.add(userDirectiveClass);
        return this;
    }

    /**
     * 获取默认指令
     *
     * @return r
     */
    public List<Class<? extends BaseTemplateDirective>> getUserDirective() {
        return userDirectiveList;
    }

    /**
     * 获取默认指令
     *
     * @return r
     */
    public List<Class<? extends BaseTemplateDirective>> defaultDirective() {
        return List.of(ContentListDirective.class, ChannelListDirective.class);
    }

}