/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseService;
import cool.scx.bo.Query;
import cool.scx.bo.Where;
import cool.scx.enumeration.WhereType;
import cool.scx.ext.organization.Role;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserRole;
import cool.scx.ext.organization.UserRoleService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@ScxService
public class RoleService
extends BaseService<Role> {
    private final UserRoleService userRoleService;

    public RoleService(UserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    public List<Role> getRoleListByUser(User user) {
        try {
            List<Long> roleIds = this.userRoleService.list(new Query().equal("userId", (Object)user.id)).stream().map(userRole -> userRole.roleId).toList();
            if (roleIds.size() > 0) {
                return this.list(new Query().in("id", roleIds));
            }
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
        }
        return new ArrayList<Role>();
    }

    public List<UserRole> getUserRoleByUserIds(List<Long> userIds) {
        try {
            return this.userRoleService.list(new Query().in("userId", userIds));
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            return new ArrayList<UserRole>();
        }
    }

    public void saveRoleListWithUserId(Long userId, List<Long> roleIds) throws SQLException {
        if (roleIds != null) {
            List idArr = roleIds.stream().filter(Objects::nonNull).map(id -> {
                UserRole userRole = new UserRole();
                userRole.userId = userId;
                userRole.roleId = id;
                return userRole;
            }).collect(Collectors.toList());
            this.userRoleService.save(idArr);
        }
    }

    public void deleteByUserId(Long id) throws SQLException {
        Where where = new Where("userId", WhereType.EQUAL, (Object)id);
        this.userRoleService.delete(where);
    }
}

