/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.exception.NoPermException;
import cool.scx.exception.UnauthorizedException;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.auth.OrganizationAuth;
import cool.scx.ext.organization.auth.OrganizationAuthPerms;
import cool.scx.web.handler.scx_mapping.ScxMappingHandler;
import cool.scx.web.handler.scx_mapping.processor.ScxMappingPreProcessor;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;

public final class OrganizationAuthPreProcessor
implements ScxMappingPreProcessor {
    private final Map<ScxMappingHandler, OrganizationAuthPerms> SCX_AUTH_PERMS_CACHE = new HashMap<ScxMappingHandler, OrganizationAuthPerms>();

    public void handle(RoutingContext context, ScxMappingHandler scxMappingHandler) throws Exception {
        OrganizationAuthPerms p = this.getScxAuthPerms(scxMappingHandler);
        if (p.checkedLogin) {
            User currentUser = OrganizationAuth.getLoginUser(context);
            if (currentUser == null) {
                throw new UnauthorizedException();
            }
            if (p.checkedPerms && !currentUser.isAdmin && !OrganizationAuth.getPerms(currentUser).contains(p.permStr)) {
                throw new NoPermException();
            }
        }
    }

    private OrganizationAuthPerms getScxAuthPerms(ScxMappingHandler s) {
        OrganizationAuthPerms p = this.SCX_AUTH_PERMS_CACHE.get(s);
        if (p == null) {
            OrganizationAuthPerms scxMappingHandlerPerms = new OrganizationAuthPerms(s.clazz, s.method);
            this.SCX_AUTH_PERMS_CACHE.put(s, scxMappingHandlerPerms);
            return scxMappingHandlerPerms;
        }
        return p;
    }
}

