package cool.scx.ext.organization;

import cool.scx.annotation.FromBody;
import cool.scx.annotation.ScxMapping;
import cool.scx.bo.Query;
import cool.scx.enumeration.HttpMethod;
import cool.scx.vo.Json;

import java.sql.SQLException;

@ScxMapping("api/dept")
public class DeptController {
    DeptService deptService;

    public DeptController(DeptService deptService) {
        this.deptService = deptService;
    }

    @ScxMapping(method = HttpMethod.DELETE)
    public Json deleteDept(@FromBody Long id) throws SQLException {
        deleteDeptWithChildren(id);
        return Json.ok();
    }

    /**
     * 递归删除 部门节点
     *
     * @param id id
     * @throws SQLException q
     */
    private void deleteDeptWithChildren(Long id) throws SQLException {
        //先删除当前节点
        deptService.delete(id);
        //拼一个查询条件先
        var q = new Query().equal("parentId", id);
        //找一下当前节点的子节点
        var parentId = deptService.list(q);
        //在删除所有当前节点的子节点 注意顺序不要乱不然删完了就查不到了
        deptService.delete(q.where());
        //循环删除 当前子节点下的所有(孙)节点
        for (var dept1 : parentId) {
            deleteDeptWithChildren(dept1.id);
        }
    }

}
