package cool.scx.ext.crud;

import cool.scx.ScxModule;
import cool.scx.util.ansi.Ansi;

/**
 * 提供一些简单的增删改查功能
 *
 * @author scx567888
 * @version 1.3.0
 */
public class CRUDModule implements ScxModule {

    /**
     * 默认实现类
     */
    private Class<? extends CRUDHandler> crudHandlerClass = CRUDHandlerImpl.class;

    /**
     * <p>Constructor for CmsModule.</p>
     */
    public CRUDModule() {

    }

    /**
     * @param c c
     */
    public CRUDModule(Class<? extends CRUDHandler> c) {
        crudHandlerClass = c;
    }

    @Override
    public void start() {
        Ansi.out().brightBlue("CRUDHandler 实现类  -->  " + this.crudHandlerClass.getName()).println();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String name() {
        return "SCX-CRUDModule";
    }

    /**
     * 获取 crudHandler
     *
     * @return c
     */
    public Class<? extends CRUDHandler> crudHandlerClass() {
        return crudHandlerClass;
    }

}