/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.annotation.ScxWebSocketMapping;
import cool.scx.base.BaseWebSocketHandler;
import cool.scx.ext.core.WSBody;
import cool.scx.ext.core.WSParamHandlerRegister;
import cool.scx.util.ObjectUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocketFrame;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScxWebSocketMapping(value="/scx")
public class CoreWebSocketHandler
implements BaseWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(CoreWebSocketHandler.class);
    private static final String LOVE = "\u2764";
    private static final List<ServerWebSocket> SERVER_WEB_SOCKETS = new ArrayList<ServerWebSocket>();

    public static ServerWebSocket getWebSocket(String binaryHandlerID) {
        return SERVER_WEB_SOCKETS.stream().filter(f -> f.binaryHandlerID().equals(binaryHandlerID)).findAny().orElse(null);
    }

    public static List<ServerWebSocket> getAllWebSockets() {
        return SERVER_WEB_SOCKETS;
    }

    public void onOpen(ServerWebSocket webSocket) {
        SERVER_WEB_SOCKETS.add(webSocket);
        logger.debug("{} \u8fde\u63a5\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)webSocket.binaryHandlerID(), (Object)CoreWebSocketHandler.getAllWebSockets().size());
    }

    public void onClose(ServerWebSocket webSocket) {
        SERVER_WEB_SOCKETS.removeIf(f -> f.binaryHandlerID().equals(webSocket.binaryHandlerID()));
        logger.debug("{} \u5173\u95ed\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)webSocket.binaryHandlerID(), (Object)CoreWebSocketHandler.getAllWebSockets().size());
    }

    public void onTextMessage(String textData, WebSocketFrame h, ServerWebSocket webSocket) throws JsonProcessingException {
        if (LOVE.equals(textData)) {
            webSocket.writeTextMessage(LOVE);
        } else {
            WSBody wsBody = (WSBody)ObjectUtils.jsonMapper().readValue(textData, WSBody.class);
            WSParamHandlerRegister.findAndHandle(wsBody, webSocket);
        }
    }

    public void onBinaryMessage(Buffer binaryData, WebSocketFrame h, ServerWebSocket webSocket) {
        Ansi.out().color((Object)"onBinaryMessage", new AnsiElement[0]).println();
    }

    public void onError(Throwable event, ServerWebSocket webSocket) {
        SERVER_WEB_SOCKETS.removeIf(f -> f.binaryHandlerID().equals(webSocket.binaryHandlerID()));
        event.printStackTrace();
    }
}

