/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.ScxContext;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.FromPath;
import cool.scx.annotation.ScxMapping;
import cool.scx.base.BaseModel;
import cool.scx.enumeration.HttpMethod;
import cool.scx.ext.crud.CRUDApiInfo;
import cool.scx.ext.crud.CRUDApiType;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListParam;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.crud.CRUDUpdateParam;
import cool.scx.ext.crud.exception.CRUDApiAlreadyDisableException;
import cool.scx.vo.BaseVo;
import cool.scx.vo.DataJson;
import cool.scx.vo.Json;
import java.util.Map;

@ScxMapping(value="api/crud")
public class CRUDController {
    private final CRUDHandler crudHandler;

    public CRUDController() {
        Class<? extends CRUDHandler> crudHandlerClass = ((CRUDModule)ScxContext.findScxModule(CRUDModule.class)).crudHandlerClass();
        this.crudHandler = (CRUDHandler)ScxContext.getBean(crudHandlerClass);
    }

    private static void checkHasThisApi(String modelName, CRUDApiType apiType) {
        CRUDApiInfo crudApiInfo = CRUDHelper.getCRUDApiInfo(modelName);
        boolean hasThisApi = crudApiInfo.hasThisApi(apiType);
        if (!hasThisApi) {
            throw new CRUDApiAlreadyDisableException(modelName, apiType);
        }
    }

    @ScxMapping(value=":modelName/list", method={HttpMethod.POST})
    public Json list(@FromPath String modelName, CRUDListParam crudListParam) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.LIST);
        CRUDListResult crudListResult = this.crudHandler.list(modelName, crudListParam);
        return Json.ok().put("items", crudListResult.list()).put("total", (Object)crudListResult.total());
    }

    @ScxMapping(value=":modelName/:id", method={HttpMethod.GET})
    public BaseVo info(@FromPath String modelName, @FromPath Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.INFO);
        BaseModel info = this.crudHandler.info(modelName, id);
        return DataJson.ok().data((Object)info);
    }

    @ScxMapping(value=":modelName", method={HttpMethod.POST})
    public BaseVo save(@FromPath String modelName, @FromBody(useAllBody=true) Map<String, Object> saveModel) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.SAVE);
        BaseModel savedModel = this.crudHandler.save(modelName, saveModel);
        return DataJson.ok().data((Object)savedModel);
    }

    @ScxMapping(value=":modelName", method={HttpMethod.PUT})
    public BaseVo update(@FromPath String modelName, CRUDUpdateParam crudUpdateParam) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.UPDATE);
        BaseModel updatedModel = this.crudHandler.update(modelName, crudUpdateParam);
        return DataJson.ok().data((Object)updatedModel);
    }

    @ScxMapping(value=":modelName/:id", method={HttpMethod.DELETE})
    public Json delete(@FromPath String modelName, @FromPath Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.DELETE);
        boolean b = this.crudHandler.delete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/batch-delete", method={HttpMethod.DELETE})
    public Json batchDelete(@FromPath String modelName, @FromBody long[] deleteIDs) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.BATCH_DELETE);
        long deletedCount = this.crudHandler.batchDelete(modelName, deleteIDs);
        return Json.ok().put("deletedCount", (Object)deletedCount);
    }

    @ScxMapping(value=":modelName/revoke-delete/:id", method={HttpMethod.GET})
    public Json revokeDelete(@FromPath String modelName, @FromPath Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.REVOKE_DELETE);
        if (!ScxContext.easyConfig().tombstone()) {
            return Json.fail((String)"not-used-tombstone");
        }
        boolean b = this.crudHandler.revokeDelete(modelName, id);
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(value=":modelName/check-unique/:fieldName", method={HttpMethod.POST})
    public Json checkUnique(@FromPath String modelName, @FromPath String fieldName, @FromBody Object value, @FromBody(required=false) Long id) {
        CRUDController.checkHasThisApi(modelName, CRUDApiType.CHECK_UNIQUE);
        boolean isUnique = this.crudHandler.checkUnique(modelName, fieldName, value, id);
        return Json.ok().put("isUnique", (Object)isUnique);
    }
}

