/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.directive;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseTemplateDirective;
import cool.scx.base.Query;
import cool.scx.ext.cms.content.ContentService;
import cool.scx.ext.cms.directive.ListDirectiveHelper;
import cool.scx.sql.where.WhereOption;
import cool.scx.util.ObjectUtils;
import java.util.Map;

@ScxService
public class ContentListDirective
implements BaseTemplateDirective {
    private final ContentService contentService;

    public ContentListDirective(ContentService contentService) {
        this.contentService = contentService;
    }

    public Object handle(Map<String, Object> params) {
        Query query = ListDirectiveHelper.createNormalListQuery(params);
        Long channelID = (Long)ObjectUtils.convertValue((Object)params.get("channelID"), Long.class);
        Boolean hasContentTitleImage = (Boolean)ObjectUtils.convertValue((Object)params.get("hasContentTitleImage"), Boolean.class);
        if (channelID != null) {
            query.equal("channelID", (Object)channelID, new WhereOption[0]);
        }
        if (hasContentTitleImage != null) {
            if (hasContentTitleImage.booleanValue()) {
                query.isNotNull("contentTitleImage", new WhereOption[0]);
            } else {
                query.isNull("contentTitleImage", new WhereOption[0]);
            }
        }
        return this.contentService.list(query);
    }

    public String directiveName() {
        return "content_list_tag";
    }

    public String variableName() {
        return "content_list";
    }
}

