/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.ScxContext;
import cool.scx.ScxHandler;
import cool.scx.ext.core.WSParam;
import cool.scx.ext.core.WSParamHandlerRegister;
import cool.scx.ext.organization.auth.AlreadyLoginClient;
import cool.scx.ext.organization.auth.AlreadyLoginClientMap;
import cool.scx.ext.organization.auth.DeviceType;
import cool.scx.ext.organization.auth.PermsAnnotationInterceptor;
import cool.scx.ext.organization.auth.PermsModel;
import cool.scx.ext.organization.auth.PermsWrapper;
import cool.scx.ext.organization.auth.ScxAuthCookieHandler;
import cool.scx.ext.organization.auth.ThirdPartyLoginHandler;
import cool.scx.ext.organization.dept.DeptService;
import cool.scx.ext.organization.exception.AuthException;
import cool.scx.ext.organization.exception.UnknownDeviceException;
import cool.scx.ext.organization.exception.UnknownLoginHandlerException;
import cool.scx.ext.organization.role.RoleService;
import cool.scx.ext.organization.user.User;
import cool.scx.ext.organization.user.UserService;
import cool.scx.mvc.interceptor.ScxMappingInterceptor;
import cool.scx.util.ObjectUtils;
import cool.scx.util.RandomUtils;
import cool.scx.util.StringUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class ScxAuth {
    static final String SCX_AUTH_TOKEN_KEY = "S-Token";
    static final String SCX_AUTH_DEVICE_KEY = "S-Device";
    private static final AlreadyLoginClientMap ALREADY_LOGIN_CLIENT_MAP = new AlreadyLoginClientMap();
    private static final Path SCX_SESSION_CACHE_PATH = ScxContext.getPathByAppRoot((String)"AppRoot:scx-session.cache");
    private static final Map<String, ThirdPartyLoginHandler> THIRD_PARTY_LOGIN_HANDLER_MAP = new HashMap<String, ThirdPartyLoginHandler>();
    private static UserService userService;
    private static RoleService roleService;
    private static DeptService deptService;

    public static void initAuth() {
        WSParamHandlerRegister.addHandler("bind-websocket-by-token", (ScxHandler<WSParam>)((ScxHandler)ScxAuth::bindWebSocketByToken));
        ScxContext.scxMappingConfiguration().setScxMappingInterceptor((ScxMappingInterceptor)new PermsAnnotationInterceptor());
        ScxContext.router().corsHandler().allowedHeader(SCX_AUTH_TOKEN_KEY).allowedHeader(SCX_AUTH_DEVICE_KEY);
        ScxContext.router().vertxRouter().route().order(1).handler((Handler)new ScxAuthCookieHandler());
        userService = (UserService)((Object)ScxContext.getBean(UserService.class));
        roleService = (RoleService)((Object)ScxContext.getBean(RoleService.class));
        deptService = (DeptService)((Object)ScxContext.getBean(DeptService.class));
    }

    public static User getLoginUser() {
        return ScxAuth.getLoginUser(ScxContext.routingContext());
    }

    public static PermsWrapper getPerms() {
        return ScxAuth.getPerms(ScxAuth.getLoginUser());
    }

    public static void readSessionFromFile() {
        try (InputStream f = Files.newInputStream(SCX_SESSION_CACHE_PATH, new OpenOption[0]);){
            AlreadyLoginClient[] clients = (AlreadyLoginClient[])ObjectUtils.jsonMapper().readValue(f, (TypeReference)new TypeReference<AlreadyLoginClient[]>(){});
            ALREADY_LOGIN_CLIENT_MAP.put(clients);
            Ansi.out().brightGreen((Object)("\u6210\u529f\u4ece " + SCX_SESSION_CACHE_PATH + " \u4e2d\u6062\u590d " + clients.length + " \u6761\u6570\u636e!!!"), new AnsiElement[0]).println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeSessionToFile() {
        try (OutputStream f = Files.newOutputStream(SCX_SESSION_CACHE_PATH, new OpenOption[0]);){
            f.write(ObjectUtils.toJson((Object)ALREADY_LOGIN_CLIENT_MAP.getAllAlreadyLoginClients()).getBytes(StandardCharsets.UTF_8));
            Ansi.out().red((Object)("\u4fdd\u5b58 Session \u5230 " + SCX_SESSION_CACHE_PATH + " \u4e2d!!!"), new AnsiElement[0]).println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static User getLoginUser(RoutingContext ctx) {
        return ScxAuth.getLoginUserByToken(ScxAuth.getToken(ctx));
    }

    static void addLoginItem(String token, User authUser, DeviceType loginDevice) {
        AlreadyLoginClient client = new AlreadyLoginClient();
        client.token = token;
        client.userID = authUser.id;
        client.loginDevice = loginDevice;
        ALREADY_LOGIN_CLIENT_MAP.put(client);
    }

    public static User getLoginUserByToken(String token) {
        AlreadyLoginClient client = ALREADY_LOGIN_CLIENT_MAP.getByToken(token);
        return client != null ? (User)userService.get(client.userID) : null;
    }

    public static AlreadyLoginClient getAlreadyLoginClient() {
        return ALREADY_LOGIN_CLIENT_MAP.getByToken(ScxAuth.getToken(ScxContext.routingContext()));
    }

    static String getTokenFromCookie(RoutingContext routingContext) {
        Cookie cookie = routingContext.request().getCookie(SCX_AUTH_TOKEN_KEY);
        return cookie != null ? cookie.getValue() : null;
    }

    static String getTokenFromHeader(RoutingContext routingContext) {
        return routingContext.request().getHeader(SCX_AUTH_TOKEN_KEY);
    }

    static DeviceType getDeviceTypeByHeader(RoutingContext routingContext) {
        String device = routingContext.request().getHeader(SCX_AUTH_DEVICE_KEY);
        if (device == null) {
            return DeviceType.WEBSITE;
        }
        return DeviceType.of(device);
    }

    private static String getToken(RoutingContext ctx) {
        DeviceType device = ScxAuth.getDeviceTypeByHeader(ctx);
        return switch (device) {
            case DeviceType.WEBSITE -> ScxAuth.getTokenFromCookie(ctx);
            case DeviceType.ADMIN, DeviceType.APPLE, DeviceType.ANDROID -> ScxAuth.getTokenFromHeader(ctx);
            default -> null;
        };
    }

    static void removeAuthUser(RoutingContext ctx) {
        ALREADY_LOGIN_CLIENT_MAP.removeByToken(ScxAuth.getToken(ctx));
    }

    private static void bindWebSocketByToken(WSParam wsParam) {
        AlreadyLoginClient alreadyLoginClient;
        Map objectMap = (Map)ObjectUtils.convertValue((Object)wsParam.data(), (TypeReference)ObjectUtils.MAP_TYPE);
        String token = (String)ObjectUtils.convertValue(objectMap.get("token"), String.class);
        String binaryHandlerID = wsParam.webSocket().binaryHandlerID();
        if (StringUtils.isNotBlank((String)token) && (alreadyLoginClient = ALREADY_LOGIN_CLIENT_MAP.getByToken(token)) != null) {
            alreadyLoginClient.webSocketBinaryHandlerID = binaryHandlerID;
        }
    }

    public static AlreadyLoginClient[] allAlreadyLoginClients() {
        return ALREADY_LOGIN_CLIENT_MAP.getAllAlreadyLoginClients();
    }

    public static PermsWrapper getPerms(User user) {
        ArrayList<PermsModel> permissionModelList = new ArrayList<PermsModel>();
        permissionModelList.addAll(deptService.getDeptListByUser(user));
        permissionModelList.addAll(roleService.getRoleListByUser(user));
        HashSet<String> pageElementPerms = new HashSet<String>();
        HashSet<String> pagePerms = new HashSet<String>();
        HashSet<String> perms = new HashSet<String>();
        HashSet<String> apiPerms = new HashSet<String>();
        for (PermsModel p : permissionModelList) {
            if (p.pagePerms != null) {
                pagePerms.addAll(p.pagePerms);
            }
            if (p.pageElementPerms != null) {
                pageElementPerms.addAll(p.pageElementPerms);
            }
            if (p.perms != null) {
                perms.addAll(p.perms);
            }
            if (p.apiPerms == null) continue;
            apiPerms.addAll(p.apiPerms);
        }
        return new PermsWrapper(perms, pagePerms, pageElementPerms, apiPerms);
    }

    private static String tryGetAuthToken(RoutingContext ctx, DeviceType loginDevice) throws AuthException {
        return switch (loginDevice) {
            default -> throw new IncompatibleClassChangeError();
            case DeviceType.ADMIN, DeviceType.APPLE, DeviceType.ANDROID -> RandomUtils.getUUID();
            case DeviceType.WEBSITE -> ScxAuth.getTokenFromCookie(ctx);
            case DeviceType.UNKNOWN -> throw new UnknownDeviceException();
        };
    }

    public static String login(String username, String password, RoutingContext ctx) {
        DeviceType loginDevice = ScxAuth.getDeviceTypeByHeader(ctx);
        String token = ScxAuth.tryGetAuthToken(ctx, loginDevice);
        User loginUser = userService.tryLogin(username, password);
        ScxAuth.addLoginItem(token, loginUser, loginDevice);
        userService.updateLastLoginDateAndIP(loginUser, "PASSWORD");
        return token;
    }

    public static String loginByThirdParty(String uniqueID, String accessToken, String accountType, RoutingContext ctx) {
        DeviceType loginDevice = ScxAuth.getDeviceTypeByHeader(ctx);
        String token = ScxAuth.tryGetAuthToken(ctx, loginDevice);
        User loginUser = ScxAuth.findThirdPartyLoginHandler(accountType).tryLogin(uniqueID, accessToken);
        ScxAuth.addLoginItem(token, loginUser, loginDevice);
        userService.updateLastLoginDateAndIP(loginUser, accountType);
        return token;
    }

    public static User signupByThirdParty(String uniqueID, String accessToken, String accountType) {
        User defaultNewUser = new User();
        defaultNewUser.username = "scx_" + RandomUtils.getRandomString((int)8, (boolean)true);
        defaultNewUser.isAdmin = false;
        return ScxAuth.findThirdPartyLoginHandler(accountType).signup(uniqueID, accessToken, defaultNewUser);
    }

    public static ThirdPartyLoginHandler findThirdPartyLoginHandler(String type) {
        ThirdPartyLoginHandler thirdPartyLoginHandler = THIRD_PARTY_LOGIN_HANDLER_MAP.get(type);
        if (thirdPartyLoginHandler == null) {
            throw new UnknownLoginHandlerException();
        }
        return thirdPartyLoginHandler;
    }

    public static void addThirdPartyLoginHandler(String type, ThirdPartyLoginHandler thirdPartyLoginHandler) {
        THIRD_PARTY_LOGIN_HANDLER_MAP.put(type, thirdPartyLoginHandler);
    }

    public static AlreadyLoginClientMap alreadyLoginClientMap() {
        return ALREADY_LOGIN_CLIENT_MAP;
    }
}

