/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.user;

import com.google.common.collect.ArrayListMultimap;
import cool.scx.ScxContext;
import cool.scx.annotation.ScxService;
import cool.scx.base.BaseModel;
import cool.scx.base.BaseModelService;
import cool.scx.base.Query;
import cool.scx.base.SelectFilter;
import cool.scx.ext.organization.auth.ScxAuth;
import cool.scx.ext.organization.dept.DeptService;
import cool.scx.ext.organization.dept.UserDept;
import cool.scx.ext.organization.exception.UnknownUserException;
import cool.scx.ext.organization.exception.UsernameAlreadyExists;
import cool.scx.ext.organization.exception.WrongPasswordException;
import cool.scx.ext.organization.role.RoleService;
import cool.scx.ext.organization.role.UserRole;
import cool.scx.ext.organization.user.User;
import cool.scx.http.exception.impl.NoPermException;
import cool.scx.http.exception.impl.UnauthorizedException;
import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.sql.where.WhereOption;
import cool.scx.util.CryptoUtils;
import cool.scx.util.NetUtils;
import cool.scx.util.StringUtils;
import io.vertx.core.http.HttpServerRequest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScxService
public class UserService
extends BaseModelService<User> {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    private final DeptService deptService;
    private final RoleService roleService;

    public UserService(DeptService deptService, RoleService roleService) {
        this.deptService = deptService;
        this.roleService = roleService;
    }

    public User saveWithDeptAndRole(User user) {
        user.password = this.encryptPassword(user.password);
        return (User)((Object)this.autoTransaction(() -> {
            User newUser = (User)super.add((BaseModel)user);
            this.deptService.saveDeptListWithUserID(newUser.id, user.deptIDs);
            this.roleService.saveRoleListWithUserID(newUser.id, user.roleIDs);
            return (User)this.get(newUser.id);
        }));
    }

    public User updateWithDeptAndRole(User user) {
        user.password = this.encryptPassword(user.password);
        return (User)((Object)this.autoTransaction(() -> {
            this.deptService.deleteByUserID(user.id);
            this.deptService.saveDeptListWithUserID(user.id, user.deptIDs);
            this.roleService.deleteByUserID(user.id);
            this.roleService.saveRoleListWithUserID(user.id, user.roleIDs);
            return (User)super.update((BaseModel)user);
        }));
    }

    public boolean checkThatThereIsAtLeastOneAdmin(Long id) {
        long count = this.count(new Query().equal("isAdmin", (Object)true, new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[]{WhereOption.SKIP_IF_NULL}));
        return count != 0L;
    }

    public List<User> list(Query query, SelectFilter selectFilter) {
        return this.fillDeptIDsAndRoleIDsField(super.list(query, selectFilter), query);
    }

    public List<User> fillDeptIDsAndRoleIDsField(List<User> oldList, Query query) {
        AbstractPlaceholderSQL userIDs = this.buildListSQLWithAlias(query, SelectFilter.ofIncluded((String[])new String[]{"id"}));
        List<UserDept> userDeptList = this.deptService.getUserDeptByUserIDs(userIDs);
        List<UserRole> userRoleList = this.roleService.getUserRoleByUserIDs(userIDs);
        ArrayListMultimap userIDAndDeptIDMap = ArrayListMultimap.create();
        ArrayListMultimap userIDAndRoleIDMap = ArrayListMultimap.create();
        for (UserDept userDept : userDeptList) {
            userIDAndDeptIDMap.put((Object)userDept.userID, (Object)userDept.deptID);
        }
        for (UserRole userRole : userRoleList) {
            userIDAndRoleIDMap.put((Object)userRole.userID, (Object)userRole.roleID);
        }
        return oldList.stream().peek(item -> {
            item.deptIDs = userIDAndDeptIDMap.get((Object)item.id);
            item.roleIDs = userIDAndRoleIDMap.get((Object)item.id);
        }).toList();
    }

    public final User changePasswordByAdminUser(String newPassword, Long id) {
        this.checkNowLoginUserIsAdmin();
        User needChangeUser = this.checkNeedChangeUserByID(id);
        needChangeUser.password = CryptoUtils.encryptPassword((String)this.checkNewPasswordStr(newPassword));
        return (User)this.update(needChangeUser);
    }

    public final User changePasswordBySelf(String newPassword, String password) {
        User loginUser = this.checkNowLoginUser();
        this.checkPassword(loginUser, password);
        User needChangeUser = this.checkNeedChangeUserByID(loginUser.id);
        needChangeUser.password = CryptoUtils.encryptPassword((String)this.checkNewPasswordStr(newPassword));
        return (User)this.update(needChangeUser);
    }

    public final User changeUsernameBySelf(String newUsername, String password) {
        User loginUser = this.checkNowLoginUser();
        this.checkPassword(loginUser, password);
        User needChangeUser = this.checkNeedChangeUserByID(loginUser.id);
        needChangeUser.username = this.checkNewUsernameStr(newUsername, needChangeUser.id);
        return (User)this.update(needChangeUser);
    }

    public final User checkNeedChangeUserByID(Long id) {
        User needChangeUser = (User)this.get(id, (SelectFilter)SelectFilter.ofIncluded().addIncluded(new String[]{"id", "password", "username"}));
        if (needChangeUser == null) {
            throw new UnknownUserException();
        }
        return needChangeUser;
    }

    public final String checkNewUsernameStr(String username, Long id) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("\u65b0\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        long count = this.count(new Query().equal("username", (Object)(username = username.trim()), new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[0]));
        if (count != 0L) {
            throw new UsernameAlreadyExists();
        }
        return username;
    }

    public final String checkNewUsernameStr(String username) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("\u65b0\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        long count = this.count(new Query().equal("username", (Object)(username = username.trim()), new WhereOption[0]));
        if (count != 0L) {
            throw new UsernameAlreadyExists();
        }
        return username;
    }

    public final String checkNewPasswordStr(String password) {
        if (StringUtils.isBlank((String)password)) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        return password.trim();
    }

    public final User checkNowLoginUserIsAdmin() {
        User loginUser = this.checkNowLoginUser();
        if (!loginUser.isAdmin.booleanValue()) {
            throw new NoPermException("\u975e\u7ba1\u7406\u5458\u65e0\u6743\u9650\u4fee\u6539\u7528\u6237\u7684\u7528\u6237\u540d !!!");
        }
        return loginUser;
    }

    public final User checkNowLoginUser() {
        User loginUser = ScxAuth.getLoginUser();
        if (loginUser == null) {
            throw new UnauthorizedException("\u8bf7\u767b\u5f55 !!!");
        }
        return loginUser;
    }

    public final void checkPassword(User user, String password) {
        boolean b;
        try {
            b = CryptoUtils.checkPassword((String)password, (String)user.password);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u7528\u6237\u5bc6\u7801\u65f6\u51fa\u73b0\u89e3\u7801\u9519\u8bef !!!", (Throwable)e);
            throw new WrongPasswordException();
        }
        if (!b) {
            throw new WrongPasswordException();
        }
    }

    public User tryLogin(String username, String password) {
        User needLoginUser = (User)this.get(new Query().equal("username", (Object)username, new WhereOption[0]));
        if (needLoginUser == null) {
            throw new UnknownUserException();
        }
        this.checkPassword(needLoginUser, password);
        return needLoginUser;
    }

    public User tryLoginByEmailAddress(String emailAddress, String verificationCode) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u6b64\u79cd\u767b\u5f55\u65b9\u5f0f");
    }

    public User tryLoginByPhoneNumber(String phoneNumber, String verificationCode) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u6b64\u79cd\u767b\u5f55\u65b9\u5f0f");
    }

    public String encryptPassword(String plainPassword) {
        if (StringUtils.isNotBlank((String)plainPassword)) {
            return CryptoUtils.encryptPassword((String)plainPassword.trim());
        }
        return null;
    }

    public void updateLastLoginDateAndIP(User user, String accountType) {
        User oldUser = (User)this.get(user.id);
        if (oldUser.loginInfoHistory == null) {
            oldUser.loginInfoHistory = new ArrayList<User.LoginInfo>();
        }
        String ip = NetUtils.getClientIPAddress((HttpServerRequest)ScxContext.routingContext().request());
        LocalDateTime date = LocalDateTime.now();
        oldUser.loginInfoHistory.add(new User.LoginInfo(ip, date, accountType));
        User tempUser = new User();
        tempUser.loginInfoHistory = oldUser.loginInfoHistory.subList(Math.max(oldUser.loginInfoHistory.size() - 10, 0), oldUser.loginInfoHistory.size());
        this.update(tempUser, new Query().equal("id", (Object)oldUser.id, new WhereOption[0]));
    }

    public User signup(User user) {
        user.username = this.checkNewUsernameStr(user.username);
        user.password = CryptoUtils.encryptPassword((String)this.checkNewPasswordStr(user.password));
        user.isAdmin = false;
        return (User)this.add(user);
    }
}

