/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.base.BaseModel;
import cool.scx.base.UpdateFilter;
import cool.scx.dao.ScxDaoTableInfo;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptyUpdateColumnException;
import java.util.Arrays;
import java.util.Map;

public final class CRUDUpdateParam {
    public Map<String, Object> updateModel;
    public String[] needUpdateFieldNames;

    public <B extends BaseModel> B getBaseModel(Class<B> modelClass) {
        return CRUDHelper.mapToBaseModel(this.updateModel, modelClass);
    }

    public UpdateFilter getUpdateFilter(Class<? extends BaseModel> modelClass, ScxDaoTableInfo scxDaoTableInfo) {
        if (this.needUpdateFieldNames == null) {
            return UpdateFilter.ofExcluded();
        }
        String[] legalFieldName = (String[])Arrays.stream(this.needUpdateFieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new);
        UpdateFilter updateFilter = (UpdateFilter)UpdateFilter.ofIncluded((boolean)false).addIncluded(legalFieldName);
        if (updateFilter.filter(scxDaoTableInfo.columnInfos()).length == 0) {
            throw new EmptyUpdateColumnException();
        }
        return updateFilter;
    }
}

