/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.role;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseModelService;
import cool.scx.base.Query;
import cool.scx.ext.organization.role.Role;
import cool.scx.ext.organization.role.UserRole;
import cool.scx.ext.organization.role.UserRoleService;
import cool.scx.ext.organization.user.User;
import cool.scx.sql.where.WhereOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ScxService
public class RoleService
extends BaseModelService<Role> {
    private final UserRoleService userRoleService;

    public RoleService(UserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    public List<Role> getRoleListByUser(User user) {
        List<Long> roleIDs = this.userRoleService.list(new Query().equal("userID", (Object)user.id, new WhereOption[0])).stream().map(userRole -> userRole.roleID).toList();
        return roleIDs.size() > 0 ? this.list(new Query().in("id", roleIDs, new WhereOption[0])) : new ArrayList<Role>();
    }

    public List<UserRole> getUserRoleByUserIDs(List<Long> userIDs) {
        if (userIDs.size() > 0) {
            return this.userRoleService.list(new Query().in("userID", userIDs, new WhereOption[0]));
        }
        return new ArrayList<UserRole>();
    }

    public void saveRoleListWithUserID(Long userID, List<Long> roleIDs) {
        if (roleIDs != null) {
            List<UserRole> idArr = roleIDs.stream().filter(Objects::nonNull).map(id -> {
                UserRole userRole = new UserRole();
                userRole.userID = userID;
                userRole.roleID = id;
                return userRole;
            }).toList();
            this.userRoleService.add(idArr);
        }
    }

    public void deleteByUserID(Long id) {
        this.userRoleService.delete(new Query().equal("userID", (Object)id, new WhereOption[0]));
    }
}

