/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.ext.organization.auth.AlreadyLoginClient;
import cool.scx.ext.organization.auth.DeviceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AlreadyLoginClientMap {
    private final List<AlreadyLoginClient> list = new ArrayList<AlreadyLoginClient>();

    public void put(AlreadyLoginClient ... alreadyLoginClient) {
        Collections.addAll(this.list, alreadyLoginClient);
    }

    public AlreadyLoginClient[] getByUserID(Long userID) {
        return (AlreadyLoginClient[])this.list.stream().filter(c -> c.userID.equals(userID)).toArray(AlreadyLoginClient[]::new);
    }

    public AlreadyLoginClient[] getByLoginDevice(DeviceType deviceType) {
        return (AlreadyLoginClient[])this.list.stream().filter(c -> c.loginDevice == deviceType).toArray(AlreadyLoginClient[]::new);
    }

    public AlreadyLoginClient getByToken(String token) {
        return this.list.stream().filter(c -> c.token.equals(token)).findAny().orElse(null);
    }

    public AlreadyLoginClient getByWebSocketBinaryHandlerID(String webSocketBinaryHandlerID) {
        return this.list.stream().filter(c -> c.webSocketBinaryHandlerID.equals(webSocketBinaryHandlerID)).findAny().orElse(null);
    }

    public boolean removeByUserID(Long userID) {
        return this.list.removeIf(c -> c.userID.equals(userID));
    }

    public boolean removeByLoginDevice(DeviceType deviceType) {
        return this.list.removeIf(c -> c.loginDevice == deviceType);
    }

    public boolean removeByToken(String token) {
        return this.list.removeIf(c -> c.token.equals(token));
    }

    public boolean removeByWebSocketBinaryHandlerID(String webSocketBinaryHandlerID) {
        return this.list.removeIf(c -> c.webSocketBinaryHandlerID.equals(webSocketBinaryHandlerID));
    }

    public AlreadyLoginClient[] getAllAlreadyLoginClients() {
        return (AlreadyLoginClient[])this.list.toArray(AlreadyLoginClient[]::new);
    }
}

