/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.role;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseModelService;
import cool.scx.base.Query;
import cool.scx.base.SelectFilter;
import cool.scx.ext.organization.role.Role;
import cool.scx.ext.organization.role.UserRole;
import cool.scx.ext.organization.role.UserRoleService;
import cool.scx.ext.organization.user.User;
import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.sql.where.WhereOption;
import java.util.List;
import java.util.Objects;

@ScxService
public class RoleService
extends BaseModelService<Role> {
    private final UserRoleService userRoleService;

    public RoleService(UserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    public List<Role> getRoleListByUser(User user) {
        AbstractPlaceholderSQL roleIDs = this.userRoleService.buildListSQL(new Query().equal("userID", (Object)user.id, new WhereOption[0]), SelectFilter.ofIncluded((String[])new String[]{"roleID"}));
        return this.list(new Query().in("id", (Object)roleIDs, new WhereOption[0]));
    }

    public List<UserRole> getUserRoleByUserIDs(AbstractPlaceholderSQL<?> userIDs) {
        return this.userRoleService.list(new Query().in("userID", userIDs, new WhereOption[0]));
    }

    public void saveRoleListWithUserID(Long userID, List<Long> roleIDs) {
        if (roleIDs != null) {
            List<UserRole> idArr = roleIDs.stream().filter(Objects::nonNull).map(id -> {
                UserRole userRole = new UserRole();
                userRole.userID = userID;
                userRole.roleID = id;
                return userRole;
            }).toList();
            this.userRoleService.add(idArr);
        }
    }

    public void deleteByUserID(Long id) {
        this.userRoleService.delete(new Query().equal("userID", (Object)id, new WhereOption[0]));
    }
}

