/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.ScxContext;
import cool.scx.ScxModuleMetadata;
import cool.scx.annotation.NoColumn;
import cool.scx.base.BaseModel;
import cool.scx.base.BaseModelService;
import cool.scx.ext.crud.CRUDApiInfo;
import cool.scx.ext.crud.annotation.UseCRUDApi;
import cool.scx.ext.crud.exception.UnknownCRUDModelException;
import cool.scx.ext.crud.exception.UnknownFieldNameException;
import cool.scx.http.exception.impl.BadRequestException;
import cool.scx.http.exception.impl.NotFoundException;
import cool.scx.util.MultiMap;
import cool.scx.util.ObjectUtils;
import cool.scx.util.StringUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CRUDHelper {
    public static final Map<String, CRUDApiInfo> BASE_MODEL_NAME_CRUD_API_INFO_MAPPING = CRUDHelper.initBaseModelNameCRUDApiInfoMapping();
    private static final Logger logger = LoggerFactory.getLogger(CRUDHelper.class);
    private static final Pattern IgnoredSeparatorRegex = Pattern.compile("[-_]");
    private static final Map<Class<BaseModel>, Class<BaseModelService<BaseModel>>> BASE_MODEL_CLASS_BASE_SERVICE_CLASS_MAPPING = CRUDHelper.initBaseModelClassBaseModelServiceClassMapping();
    private static final Map<Class<BaseModel>, BaseModelService<BaseModel>> BASE_MODEL_CLASS_BASE_MODEL_SERVICE_CACHE = new HashMap<Class<BaseModel>, BaseModelService<BaseModel>>();

    public static BaseModelService<BaseModel> getBaseModelService(Class<BaseModel> baseModelClass) {
        BaseModelService baseModelService = BASE_MODEL_CLASS_BASE_MODEL_SERVICE_CACHE.get(baseModelClass);
        if (baseModelService == null) {
            Class<BaseModelService<BaseModel>> baseModelServiceClass = BASE_MODEL_CLASS_BASE_SERVICE_CLASS_MAPPING.get(baseModelClass);
            baseModelService = baseModelServiceClass != null ? (BaseModelService)ScxContext.getBean(baseModelServiceClass) : new BaseModelService(baseModelClass);
            BASE_MODEL_CLASS_BASE_MODEL_SERVICE_CACHE.put(baseModelClass, (BaseModelService<BaseModel>)baseModelService);
        }
        return baseModelService;
    }

    public static <B extends BaseModel> B mapToBaseModel(Map<String, Object> map, Class<B> baseModelClass) {
        try {
            return (B)((BaseModel)ObjectUtils.convertValue(map, baseModelClass));
        }
        catch (Exception e) {
            logger.error("\u5c06 Map \u8f6c\u6362\u4e3a BaseModel \u65f6\u53d1\u751f\u5f02\u5e38 : ", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
    }

    public static CRUDApiInfo getCRUDApiInfo(String baseModelName) throws NotFoundException {
        if (StringUtils.isBlank((String)baseModelName)) {
            throw new UnknownCRUDModelException(baseModelName);
        }
        String finalBaseModelName = IgnoredSeparatorRegex.matcher(baseModelName).replaceAll("").toLowerCase();
        CRUDApiInfo baseModelClass = BASE_MODEL_NAME_CRUD_API_INFO_MAPPING.get(finalBaseModelName);
        if (baseModelClass == null) {
            throw new UnknownCRUDModelException(baseModelName);
        }
        return baseModelClass;
    }

    private static HashMap<String, CRUDApiInfo> initBaseModelNameCRUDApiInfoMapping() {
        HashMap<String, CRUDApiInfo> tempMap = new HashMap<String, CRUDApiInfo>();
        for (ScxModuleMetadata m : ScxContext.scxModuleMetadataList()) {
            for (Class c : m.scxBaseModelClassList()) {
                UseCRUDApi useCRUDApiAnnotation = c.getAnnotation(UseCRUDApi.class);
                if (useCRUDApiAnnotation == null) continue;
                CRUDApiInfo crudApiInfo = new CRUDApiInfo(useCRUDApiAnnotation, c);
                CRUDApiInfo last = tempMap.get(crudApiInfo.baseModelName);
                tempMap.put(crudApiInfo.baseModelName, crudApiInfo);
                if (last == null) continue;
                Ansi.out().brightRed((Object)"\u68c0\u6d4b\u5230\u91cd\u590d\u540d\u79f0\u7684 BaseModel ", new AnsiElement[0]).brightYellow((Object)("[" + last.baseModelClass.getName() + "] "), new AnsiElement[0]).blue((Object)("[" + c.getName() + "]"), new AnsiElement[0]).brightRed((Object)" \u53ef\u80fd\u4f1a\u5bfc\u81f4\u6839\u636e\u540d\u79f0\u8c03\u7528\u65f6\u610f\u4e49\u4e0d\u660e\u786e !!! \u5efa\u8bae\u4fee\u6539 !!!", new AnsiElement[0]).println();
            }
        }
        return tempMap;
    }

    private static Map<Class<BaseModel>, Class<BaseModelService<BaseModel>>> initBaseModelClassBaseModelServiceClassMapping() {
        MultiMap classClassHashSetValuedHashMap = new MultiMap();
        List<Class> baseModelClassList = BASE_MODEL_NAME_CRUD_API_INFO_MAPPING.values().stream().map(c -> c.baseModelClass).toList();
        for (ScxModuleMetadata m : ScxContext.scxModuleMetadataList()) {
            for (Class c2 : m.scxBaseModelServiceClassList()) {
                Type[] typeArguments = ((ParameterizedType)c2.getGenericSuperclass()).getActualTypeArguments();
                Class baseModelClass = (Class)typeArguments[0];
                if (!baseModelClassList.contains(baseModelClass)) continue;
                classClassHashSetValuedHashMap.put((Object)baseModelClass, (Object)c2);
            }
        }
        HashMap<Class<BaseModel>, Class<BaseModelService<BaseModel>>> tempMap = new HashMap<Class<BaseModel>, Class<BaseModelService<BaseModel>>>();
        for (Class key : classClassHashSetValuedHashMap.keySet()) {
            List classes = classClassHashSetValuedHashMap.get((Object)key);
            Class lastThisBaseModelClassBaseModelServiceClass = (Class)classes.get(classes.size() - 1);
            if (classes.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < classes.size() - 1; ++i) {
                    String name = ((Class)classes.get(i)).getName();
                    if (i == classes.size() - 2) {
                        sb.append("[").append(name).append("] ");
                        continue;
                    }
                    sb.append("[").append(name).append("],");
                }
                Ansi.out().brightRed((Object)("\u68c0\u6d4b\u5230\u9488\u5bf9 " + key.getName() + " \u7684\u591a\u4e2a BaseModelService \u5b9e\u73b0 , \u5df2\u91c7\u7528\u6700\u540e\u4e00\u4e2a [" + lastThisBaseModelClassBaseModelServiceClass.getName() + "] ,"), new AnsiElement[0]).brightYellow((Object)(" \u5176\u4f59\u7684 BaseModelService \u5b9e\u73b0 " + sb), new AnsiElement[0]).println();
            }
            tempMap.put(key, lastThisBaseModelClassBaseModelServiceClass);
        }
        return tempMap;
    }

    public static String checkFieldName(Class<?> modelClass, String fieldName) throws UnknownFieldNameException {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new UnknownFieldNameException(fieldName);
            }
        }
        catch (Exception e) {
            throw new UnknownFieldNameException(fieldName);
        }
        return fieldName;
    }
}

