/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.ScxContext;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSObject;
import cool.scx.ext.fss.FSSObjectService;
import cool.scx.http.exception.impl.InternalServerErrorException;
import cool.scx.http.exception.impl.NotFoundException;
import cool.scx.type.UploadedEntity;
import cool.scx.util.Cache;
import cool.scx.util.DigestUtils;
import cool.scx.util.FileUtils;
import cool.scx.util.RandomUtils;
import cool.scx.vo.BaseVo;
import cool.scx.vo.DataJson;
import cool.scx.vo.Download;
import cool.scx.vo.Image;
import cool.scx.vo.Json;
import cool.scx.vo.Raw;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public abstract class FSSHandler {
    private static final Cache<String, Image> IMAGE_CACHE = new Cache(10000);
    private final FSSObjectService fssObjectService;

    public FSSHandler(FSSObjectService fssObjectService) {
        this.fssObjectService = fssObjectService;
    }

    public FSSHandler() {
        this.fssObjectService = (FSSObjectService)((Object)ScxContext.getBean(FSSObjectService.class));
    }

    public static Integer getLastUploadChunk(Path uploadConfigFile, Integer chunkLength) throws IOException {
        try {
            String allStr = Files.readString(uploadConfigFile);
            return Integer.parseInt(allStr.split("_")[0]);
        }
        catch (Exception e) {
            FSSHandler.updateLastUploadChunk(uploadConfigFile, -1, chunkLength);
            return -1;
        }
    }

    public static void updateLastUploadChunk(Path uploadConfigFile, Integer nowChunkIndex, Integer chunkLength) throws IOException {
        String str = nowChunkIndex + "_" + chunkLength;
        FileUtils.write((Path)uploadConfigFile, (byte[])str.getBytes(StandardCharsets.UTF_8), (OpenOption[])new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
    }

    public static FSSObject createFSSObjectByFileInfo(String fileName, Long fileSize, String fileMD5) {
        LocalDateTime now = LocalDateTime.now();
        String yearStr = "" + now.getYear();
        String monthStr = "" + now.getMonthValue();
        String dayStr = "" + now.getDayOfMonth();
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.randomUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = now;
        fssObject.fileSizeDisplay = FileUtils.longToDisplaySize((long)fileSize);
        fssObject.fileSize = fileSize;
        fssObject.fileMD5 = fileMD5;
        fssObject.fileExtension = FileUtils.getFileExtension((String)fssObject.fileName);
        fssObject.filePath = new String[]{yearStr, monthStr, dayStr, fileMD5, fileName};
        return fssObject;
    }

    public static Path getUploadTempPath(String fileMD5) {
        return FSSConfig.uploadFilePath().resolve("TEMP").resolve(fileMD5);
    }

    public static Path getPhysicalFilePath(FSSObject fssObject) {
        return Path.of(FSSConfig.uploadFilePath().toString(), fssObject.filePath);
    }

    public FSSObject copyFSSObject(String fileName, FSSObject oldFSSObject) {
        FSSObject fssObject = new FSSObject();
        fssObject.fssObjectID = RandomUtils.randomUUID();
        fssObject.fileName = fileName;
        fssObject.uploadTime = LocalDateTime.now();
        fssObject.filePath = oldFSSObject.filePath;
        fssObject.fileSizeDisplay = oldFSSObject.fileSizeDisplay;
        fssObject.fileSize = oldFSSObject.fileSize;
        fssObject.fileMD5 = oldFSSObject.fileMD5;
        fssObject.fileExtension = FileUtils.getFileExtension((String)fssObject.fileName);
        return fssObject;
    }

    public FSSObject checkFSSObjectID(String fssObjectID) {
        FSSObject fssObject = this.fssObjectService.findByFSSObjectID(fssObjectID);
        if (fssObject == null) {
            throw new NotFoundException();
        }
        return fssObject;
    }

    public Path checkPhysicalFile(FSSObject fssObject) throws NotFoundException {
        Path physicalFile = FSSHandler.getPhysicalFilePath(fssObject);
        if (Files.notExists(physicalFile, new LinkOption[0])) {
            throw new NotFoundException();
        }
        return physicalFile;
    }

    public Download download(String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        Path file = this.checkPhysicalFile(fssObject);
        return Download.of((Path)file, (String)fssObject.fileName);
    }

    public Image image(String fssObjectID, Integer width, Integer height, String type) {
        String cacheKey = fssObjectID + " " + width + " " + height + " " + type;
        return (Image)IMAGE_CACHE.computeIfAbsent((Object)cacheKey, k -> {
            FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
            Path file = this.checkPhysicalFile(fssObject);
            return Image.of((File)file.toFile(), (Integer)width, (Integer)height, (String)type);
        });
    }

    public Raw raw(String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        Path file = this.checkPhysicalFile(fssObject);
        return Raw.of((Path)file);
    }

    public Json upload(String fileName, Long fileSize, String fileMD5, Integer chunkLength, Integer nowChunkIndex, UploadedEntity fileData) throws IOException {
        Path uploadTempFile = FSSHandler.getUploadTempPath(fileMD5).resolve("scx_fss.temp");
        Path uploadConfigFile = uploadTempFile.resolveSibling("scx_fss.upload_state");
        if (nowChunkIndex == chunkLength - 1) {
            FileUtils.write((Path)uploadTempFile, (byte[])fileData.buffer().getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
            FSSObject newFSSObject = FSSHandler.createFSSObjectByFileInfo(fileName, fileSize, fileMD5);
            Path fileStoragePath = Path.of(FSSConfig.uploadFilePath().toString(), newFSSObject.filePath);
            String serverMd5Str = DigestUtils.md5((File)uploadTempFile.toFile());
            if (!fileMD5.equalsIgnoreCase(serverMd5Str)) {
                FileUtils.delete((Path)uploadTempFile.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                throw new InternalServerErrorException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25 : MD5 \u6821\u9a8c\u5931\u8d25 , \u6587\u4ef6 : " + fileMD5);
            }
            FileUtils.move((Path)uploadTempFile, (Path)fileStoragePath, (CopyOption[])new CopyOption[0]);
            fileStoragePath.toFile().setReadOnly();
            FileUtils.delete((Path)uploadTempFile.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
            FSSObject save = (FSSObject)this.fssObjectService.add(newFSSObject);
            return Json.ok().put("type", (Object)"upload-success").put("item", (Object)save);
        }
        Integer lastUploadChunk = FSSHandler.getLastUploadChunk(uploadConfigFile, chunkLength);
        int needUploadChunkIndex = lastUploadChunk + 1;
        if (nowChunkIndex.equals(needUploadChunkIndex)) {
            FileUtils.write((Path)uploadTempFile, (byte[])fileData.buffer().getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
            FSSHandler.updateLastUploadChunk(uploadConfigFile, nowChunkIndex, chunkLength);
            return Json.ok().put("type", (Object)"need-more").put("item", (Object)(needUploadChunkIndex + 1));
        }
        return Json.ok().put("type", (Object)"need-more").put("item", (Object)needUploadChunkIndex);
    }

    public Json delete(String fssObjectID) throws IOException {
        FSSObject needDeleteFile = this.fssObjectService.findByFSSObjectID(fssObjectID);
        if (needDeleteFile != null) {
            long count = this.fssObjectService.countByMD5(needDeleteFile.fileMD5);
            if (count <= 1L) {
                Path filePath = FSSHandler.getPhysicalFilePath(needDeleteFile);
                try {
                    FileUtils.delete((Path)filePath.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            this.fssObjectService.delete(new long[]{needDeleteFile.id});
        }
        return Json.ok();
    }

    public BaseVo listInfo(List<String> fssObjectIDs) {
        if (fssObjectIDs != null && fssObjectIDs.size() > 0) {
            return DataJson.ok().data(this.fssObjectService.findByFSSObjectIDs(fssObjectIDs));
        }
        return DataJson.ok().data(new ArrayList());
    }

    public BaseVo info(String fssObjectID) {
        if (fssObjectID != null) {
            return DataJson.ok().data((Object)this.fssObjectService.findByFSSObjectID(fssObjectID));
        }
        return DataJson.ok().data(null);
    }

    public Json checkAnyFileExistsByThisMD5(String fileName, Long fileSize, String fileMD5) throws IOException {
        List<FSSObject> fssObjectListByMd5 = this.fssObjectService.findFSSObjectListByMD5(fileMD5);
        if (fssObjectListByMd5.size() > 0) {
            FSSObject canUseFssObject = null;
            for (FSSObject fssObject : fssObjectListByMd5) {
                File physicalFile = FSSHandler.getPhysicalFilePath(fssObject).toFile();
                if (!physicalFile.exists() || physicalFile.length() != fileSize.longValue() || !fileMD5.equalsIgnoreCase(DigestUtils.md5((File)physicalFile))) continue;
                canUseFssObject = fssObject;
                break;
            }
            if (canUseFssObject != null) {
                FSSObject save = (FSSObject)this.fssObjectService.add(this.copyFSSObject(fileName, canUseFssObject));
                FileUtils.delete((Path)FSSHandler.getUploadTempPath(fileMD5), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                return Json.ok().put("type", (Object)"upload-by-md5-success").put("item", (Object)save);
            }
        }
        return Json.fail((String)"no-any-file-exists-for-this-md5");
    }
}

