/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.dept;

import cool.scx.annotation.ScxService;
import cool.scx.base.BaseModelService;
import cool.scx.base.Query;
import cool.scx.base.SelectFilter;
import cool.scx.ext.organization.dept.Dept;
import cool.scx.ext.organization.dept.UserDept;
import cool.scx.ext.organization.dept.UserDeptService;
import cool.scx.ext.organization.user.User;
import cool.scx.sql.AbstractPlaceholderSQL;
import cool.scx.sql.where.WhereOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@ScxService
public class DeptService
extends BaseModelService<Dept> {
    private final UserDeptService userDeptService;

    public DeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    public List<Dept> getDeptListByUser(User user) {
        AbstractPlaceholderSQL deptIDs = this.userDeptService.buildListSQL(new Query().equal("userID", (Object)user.id, new WhereOption[0]), SelectFilter.ofIncluded((String[])new String[]{"deptID"}));
        return this.list(new Query().in("id", (Object)deptIDs, new WhereOption[0]));
    }

    public void saveDeptListWithUserID(Long userID, List<Long> deptIDs) {
        if (deptIDs != null) {
            List<UserDept> idArr = deptIDs.stream().filter(Objects::nonNull).map(id -> {
                UserDept userDept = new UserDept();
                userDept.userID = userID;
                userDept.deptID = id;
                return userDept;
            }).toList();
            this.userDeptService.add(idArr);
        }
    }

    public void deleteByUserID(Long id) {
        this.userDeptService.delete(new Query().equal("userID", (Object)id, new WhereOption[0]));
    }

    public List<UserDept> findDeptByUserID(Long userID) {
        if (userID != null) {
            return this.userDeptService.list(new Query().equal("userID", (Object)userID, new WhereOption[0]));
        }
        return new ArrayList<UserDept>();
    }

    public List<UserDept> getUserDeptByUserIDs(AbstractPlaceholderSQL<?> userIDs) {
        return this.userDeptService.list(new Query().in("userID", userIDs, new WhereOption[0]));
    }

    public void deleteDeptWithChildren(Long id) {
        List<Dept> deptWithChildren = this.getDeptWithChildren(id);
        this.delete(deptWithChildren.stream().mapToLong(dept -> dept.id).toArray());
    }

    public List<Dept> getDeptWithChildren(Long id) {
        ArrayList<Dept> deptWithChildren = new ArrayList<Dept>();
        this._fillDeptWithChildren(deptWithChildren, (Dept)this.get(id));
        return deptWithChildren;
    }

    private void _fillDeptWithChildren(Collection<Dept> deptWithChildren, Dept parentDept) {
        if (parentDept != null) {
            deptWithChildren.add(parentDept);
            this.list(new Query().equal("parentID", (Object)parentDept.id, new WhereOption[0]), (SelectFilter)SelectFilter.ofIncluded().addIncluded(new String[]{"id"})).forEach(child -> this._fillDeptWithChildren(deptWithChildren, (Dept)((Object)child)));
        }
    }
}

