/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.core.annotation.FromBody;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.enumeration.HttpMethod;
import cool.scx.core.http.exception.impl.UnauthorizedException;
import cool.scx.core.vo.BaseVo;
import cool.scx.core.vo.DataJson;
import cool.scx.core.vo.Json;
import cool.scx.ext.organization.annotation.Perms;
import cool.scx.ext.organization.auth.DeviceType;
import cool.scx.ext.organization.auth.ScxAuth;
import cool.scx.ext.organization.auth.ScxUserInfo;
import cool.scx.ext.organization.exception.AuthException;
import cool.scx.ext.organization.user.User;
import cool.scx.ext.organization.user.UserService;
import io.vertx.ext.web.RoutingContext;

@ScxMapping(value="/api/auth")
public class ScxAuthController {
    private final UserService userService;

    public ScxAuthController(UserService userService) {
        this.userService = userService;
    }

    @ScxMapping(method={HttpMethod.POST})
    public BaseVo login(@FromBody String username, @FromBody String password, RoutingContext ctx) {
        try {
            String token = ScxAuth.login(username, password, ctx);
            if (ScxAuth.getDeviceTypeByHeader(ctx) == DeviceType.WEBSITE) {
                return Json.fail((String)"login-successful");
            }
            return Json.ok().put("token", (Object)token);
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxMapping(method={HttpMethod.POST})
    public BaseVo loginByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType, RoutingContext ctx) {
        try {
            String token = ScxAuth.loginByThirdParty(uniqueID, accessToken, accountType, ctx);
            if (ScxAuth.getDeviceTypeByHeader(ctx) == DeviceType.WEBSITE) {
                return Json.fail((String)"login-successful");
            }
            return Json.ok().put("token", (Object)token);
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxMapping(method={HttpMethod.POST})
    public DataJson signup(@FromBody(useAllBody=true) User user) {
        User newUser = this.userService.signup(user);
        return DataJson.ok().data((Object)newUser);
    }

    @ScxMapping(method={HttpMethod.POST})
    public DataJson signupByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType) {
        User newUser = ScxAuth.signupByThirdParty(uniqueID, accessToken, accountType);
        return DataJson.ok().data((Object)newUser);
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json logout(RoutingContext routingContext) {
        ScxAuth.removeAuthUser(routingContext);
        return Json.ok();
    }

    @Perms(checkedPerms=false)
    @ScxMapping(method={HttpMethod.GET})
    public BaseVo info(RoutingContext routingContext) throws UnauthorizedException {
        User user = ScxAuth.getLoginUser(routingContext);
        return DataJson.ok().data((Object)new ScxUserInfo(user, ScxAuth.getPerms(user)));
    }

    @Perms(checkedPerms=false)
    @ScxMapping(method={HttpMethod.POST})
    public DataJson changeUserAvatar(@FromBody String newAvatar) throws UnauthorizedException {
        User loginUser = ScxAuth.getLoginUser();
        User l = new User();
        l.avatar = newAvatar;
        l.id = loginUser.id;
        return DataJson.ok().data((Object)this.userService.update(l));
    }

    @Perms(checkedPerms=false)
    @ScxMapping(method={HttpMethod.POST})
    public BaseVo changeUserUsername(@FromBody String newUsername, @FromBody String password) throws UnauthorizedException {
        try {
            return DataJson.ok().data((Object)this.userService.changeUsernameBySelf(newUsername, password));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @Perms(checkedPerms=false)
    @ScxMapping(method={HttpMethod.POST})
    public BaseVo changeUserPassword(@FromBody String newPassword, @FromBody String oldPassword) throws UnauthorizedException {
        try {
            return DataJson.ok().data((Object)this.userService.changePasswordBySelf(newPassword, oldPassword));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }
}

