/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public final class QRCodeUtils {
    public static byte[] getQRCode(String content, int widthAndHeight) {
        byte[] byArray;
        HashMap<EncodeHintType, Comparable<Charset>> hints = new HashMap<EncodeHintType, Comparable<Charset>>();
        hints.put(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8);
        hints.put(EncodeHintType.ERROR_CORRECTION, (Comparable<Charset>)ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, Integer.valueOf(2));
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            BitMatrix encode = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, widthAndHeight, widthAndHeight, hints);
            MatrixToImageWriter.writeToStream((BitMatrix)encode, (String)"png", (OutputStream)b);
            byArray = b.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    b.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        b.close();
        return byArray;
    }
}

