/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.core;

import cool.scx.core.ScxContext;
import cool.scx.ext.core.WSBody;
import cool.scx.ext.core.WSParam;
import cool.scx.functional.ScxHandler;
import cool.scx.functional.ScxHandlerA;
import cool.scx.util.MultiMap;
import cool.scx.util.StringUtils;
import io.vertx.core.http.ServerWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WSParamHandlerRegister {
    private static final Logger logger = LoggerFactory.getLogger(WSParamHandlerRegister.class);
    private static final MultiMap<String, ScxHandlerA<WSParam>> NAME_WS_PARAM_HANDLER_MAPPING = new MultiMap();

    static void findAndHandle(WSBody wsBody, ServerWebSocket webSocket) {
        if (StringUtils.notBlank((String)wsBody.name())) {
            WSParam wsParam = new WSParam(wsBody.data(), webSocket);
            for (ScxHandlerA wsParamHandler : NAME_WS_PARAM_HANDLER_MAPPING.get((Object)wsBody.name())) {
                ScxContext.scheduler().submit((ScxHandler)new WSParamHandlerWrapper((ScxHandlerA<WSParam>)wsParamHandler, wsParam));
            }
        }
    }

    public static void addHandler(String name, ScxHandlerA<WSParam> scxHandler) {
        NAME_WS_PARAM_HANDLER_MAPPING.put((Object)name, scxHandler);
    }

    public static void removeAllHandler(String name) {
        NAME_WS_PARAM_HANDLER_MAPPING.removeAll((Object)name);
    }

    public static void removeHandler(String name, ScxHandlerA<WSParam> scxHandler) {
        NAME_WS_PARAM_HANDLER_MAPPING.remove((Object)name, scxHandler);
    }

    record WSParamHandlerWrapper(ScxHandlerA<WSParam> wsParamHandler, WSParam wsParam) implements ScxHandler
    {
        public void handle() {
            try {
                this.wsParamHandler.handle((Object)this.wsParam);
            }
            catch (Throwable throwable) {
                logger.error("\u6267\u884c WSParamHandler \u51fa\u9519 !!!", throwable);
            }
        }
    }
}

