/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization;

import cool.scx.core.ScxModule;
import cool.scx.core.base.BaseModel;
import cool.scx.core.base.BaseModelService;
import cool.scx.ext.organization.auth.ScxAuth;
import cool.scx.ext.organization.base.BaseDeptService;
import cool.scx.ext.organization.base.BaseRoleService;
import cool.scx.ext.organization.base.BaseUserService;
import cool.scx.ext.organization.base.impl.Account;
import cool.scx.ext.organization.base.impl.AccountService;
import cool.scx.ext.organization.base.impl.AuthController;
import cool.scx.ext.organization.base.impl.Dept;
import cool.scx.ext.organization.base.impl.DeptController;
import cool.scx.ext.organization.base.impl.DeptService;
import cool.scx.ext.organization.base.impl.Role;
import cool.scx.ext.organization.base.impl.RoleService;
import cool.scx.ext.organization.base.impl.User;
import cool.scx.ext.organization.base.impl.UserController;
import cool.scx.ext.organization.base.impl.UserService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationModule
extends ScxModule {
    private final Logger logger = LoggerFactory.getLogger(OrganizationModule.class);
    private Class<? extends BaseUserService<?>> userServiceClass = UserService.class;
    private Class<? extends BaseDeptService<?>> deptServiceClass = DeptService.class;
    private Class<? extends BaseRoleService<?>> roleServiceClass = RoleService.class;
    private boolean enableDefaultUser = true;
    private boolean enableDefaultDept = true;
    private boolean enableDefaultRole = true;
    private boolean enableDefaultAuthApi = true;

    public Class<? extends BaseUserService<?>> getUserServiceClass() {
        return this.userServiceClass;
    }

    public OrganizationModule setUserServiceClass(Class<? extends BaseUserService<?>> userServiceClass) {
        this.userServiceClass = userServiceClass;
        return this;
    }

    public Class<? extends BaseDeptService<?>> getDeptServiceClass() {
        return this.deptServiceClass;
    }

    public OrganizationModule setDeptServiceClass(Class<? extends BaseDeptService<?>> deptServiceClass) {
        this.deptServiceClass = deptServiceClass;
        return this;
    }

    public Class<? extends BaseRoleService<?>> getRoleServiceClass() {
        return this.roleServiceClass;
    }

    public OrganizationModule setRoleServiceClass(Class<? extends BaseRoleService<?>> roleServiceClass) {
        this.roleServiceClass = roleServiceClass;
        return this;
    }

    public boolean enableDefaultUser() {
        return this.enableDefaultUser && this.userServiceClass == UserService.class;
    }

    public OrganizationModule setEnableDefaultUser(boolean enableDefaultUser) {
        this.enableDefaultUser = enableDefaultUser;
        return this;
    }

    public boolean enableDefaultDept() {
        return this.enableDefaultDept && this.deptServiceClass == DeptService.class;
    }

    public OrganizationModule setEnableDefaultDept(boolean enableDefaultDept) {
        this.enableDefaultDept = enableDefaultDept;
        return this;
    }

    public boolean enableDefaultRole() {
        return this.enableDefaultRole && this.roleServiceClass == RoleService.class;
    }

    public OrganizationModule setEnableDefaultRole(boolean enableDefaultRole) {
        this.enableDefaultRole = enableDefaultRole;
        return this;
    }

    public boolean enableDefaultAuthApi() {
        return this.enableDefaultAuthApi && this.enableDefaultUser();
    }

    public OrganizationModule setEnableDefaultAuthApi(boolean enableDefaultAuthApi) {
        this.enableDefaultAuthApi = enableDefaultAuthApi;
        return this;
    }

    public void start() {
        ScxAuth.initAuth(this.userServiceClass, this.deptServiceClass, this.roleServiceClass);
        ScxAuth.readSessionFromFile();
    }

    public List<Class<?>> scxMappingClassList() {
        ArrayList list = new ArrayList(super.scxMappingClassList());
        this.removeClass(list, "ScxMappingClassList");
        return list;
    }

    public List<Class<? extends BaseModel>> scxBaseModelClassList() {
        ArrayList<Class<? extends BaseModel>> list = new ArrayList<Class<? extends BaseModel>>(super.scxBaseModelClassList());
        this.removeClass(list, "ScxBaseModelClassList");
        return list;
    }

    public List<Class<? extends BaseModelService<?>>> scxBaseModelServiceClassList() {
        ArrayList list = new ArrayList(super.scxBaseModelServiceClassList());
        this.removeClass(list, "ScxBaseModelServiceClassList");
        return list;
    }

    private void removeClass(List<?> list, String name) {
        boolean remove2;
        boolean remove1;
        boolean remove;
        if (!this.enableDefaultAuthApi() && (remove = list.remove(AuthController.class))) {
            this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, AuthController.class);
        }
        if (!this.enableDefaultUser()) {
            remove = list.remove(User.class);
            remove1 = list.remove(UserService.class);
            remove2 = list.remove(UserController.class);
            boolean remove3 = list.remove(Account.class);
            boolean remove4 = list.remove(AccountService.class);
            if (remove) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, User.class);
            }
            if (remove1) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, UserService.class);
            }
            if (remove2) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, UserController.class);
            }
            if (remove3) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, Account.class);
            }
            if (remove4) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, AccountService.class);
            }
        }
        if (!this.enableDefaultDept()) {
            remove = list.remove(Dept.class);
            remove1 = list.remove(DeptService.class);
            remove2 = list.remove(DeptController.class);
            if (remove) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, Dept.class);
            }
            if (remove1) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, DeptService.class);
            }
            if (remove2) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, DeptController.class);
            }
        }
        if (!this.enableDefaultRole()) {
            remove = list.remove(Role.class);
            remove1 = list.remove(RoleService.class);
            if (remove) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, Role.class);
            }
            if (remove1) {
                this.logger.info("\u5df2\u4ece {} \u4e2d\u79fb\u9664 {}", (Object)name, RoleService.class);
            }
        }
    }

    public List<Class<?>> scxBeanClassList() {
        ArrayList list = new ArrayList(super.scxBeanClassList());
        this.removeClass(list, "ScxBeanClassList");
        return list;
    }

    public void stop() {
        ScxAuth.writeSessionToFile();
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }
}

