/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.core.http.exception.impl.NoPermException;
import cool.scx.core.http.exception.impl.UnauthorizedException;
import cool.scx.core.mvc.ScxMappingHandler;
import cool.scx.core.mvc.interceptor.ScxMappingInterceptor;
import cool.scx.ext.organization.annotation.Perms;
import cool.scx.ext.organization.auth.ScxAuth;
import cool.scx.ext.organization.base.BaseUser;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class PermsAnnotationInterceptor
implements ScxMappingInterceptor {
    private final Map<ScxMappingHandler, AuthPerms> SCX_AUTH_PERMS_CACHE = new HashMap<ScxMappingHandler, AuthPerms>();

    public void preHandle(RoutingContext context, ScxMappingHandler scxMappingHandler) {
        AuthPerms p = this.getScxAuthPerms(scxMappingHandler);
        if (p.checkLogin) {
            Object currentUser = ScxAuth.getLoginUser(context);
            if (currentUser == null) {
                throw new UnauthorizedException();
            }
            if (p.checkPerms && !((BaseUser)((Object)currentUser)).isAdmin.booleanValue() && !ScxAuth.getPerms(currentUser).perms().contains(p.permStr)) {
                throw new NoPermException();
            }
        }
    }

    private AuthPerms getScxAuthPerms(ScxMappingHandler s) {
        AuthPerms p = this.SCX_AUTH_PERMS_CACHE.get(s);
        if (p == null) {
            p = new AuthPerms(s.clazz, s.method);
            this.SCX_AUTH_PERMS_CACHE.put(s, p);
        }
        return p;
    }

    private static final class AuthPerms {
        public final String permStr;
        public final boolean checkLogin;
        public final boolean checkPerms;

        public AuthPerms(Class<?> clazz, Method method) {
            this.permStr = clazz.getSimpleName() + ":" + method.getName();
            Perms scxPerms = method.getAnnotation(Perms.class);
            if (scxPerms != null) {
                this.checkPerms = scxPerms.checkPerms();
                this.checkLogin = scxPerms.checkLogin();
            } else {
                this.checkPerms = false;
                this.checkLogin = false;
            }
        }
    }
}

