/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.base;

import cool.scx.core.ScxContext;
import cool.scx.core.annotation.FromBody;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.base.BaseModel;
import cool.scx.core.base.UpdateFilter;
import cool.scx.core.enumeration.HttpMethod;
import cool.scx.core.http.exception.impl.UnauthorizedException;
import cool.scx.core.vo.BaseVo;
import cool.scx.core.vo.DataJson;
import cool.scx.core.vo.Json;
import cool.scx.ext.organization.annotation.Perms;
import cool.scx.ext.organization.auth.DeviceType;
import cool.scx.ext.organization.auth.PermsWrapper;
import cool.scx.ext.organization.auth.ScxAuth;
import cool.scx.ext.organization.base.BaseUser;
import cool.scx.ext.organization.base.BaseUserService;
import cool.scx.ext.organization.exception.AuthException;
import io.vertx.ext.web.RoutingContext;

public abstract class BaseAuthController<T extends BaseUser> {
    private final BaseUserService<T> userService;

    public BaseAuthController(BaseUserService<T> userService) {
        this.userService = userService;
    }

    @ScxMapping(method={HttpMethod.POST})
    public BaseVo login(@FromBody String username, @FromBody String password, RoutingContext ctx) {
        try {
            String token = ScxAuth.login(username, password, ctx);
            if (ScxAuth.getDeviceTypeByHeader(ctx) == DeviceType.WEBSITE) {
                return Json.fail((String)"login-successful");
            }
            return Json.ok().put("token", (Object)token);
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxMapping(method={HttpMethod.POST})
    public BaseVo loginByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType, RoutingContext ctx) {
        try {
            String token = ScxAuth.loginByThirdParty(uniqueID, accessToken, accountType, ctx);
            if (ScxAuth.getDeviceTypeByHeader(ctx) == DeviceType.WEBSITE) {
                return Json.fail((String)"login-successful");
            }
            return Json.ok().put("token", (Object)token);
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxMapping(method={HttpMethod.POST})
    public DataJson signup(@FromBody(useAllBody=true) T user) {
        T newUser = this.userService.signup(user);
        return DataJson.ok().data(newUser);
    }

    @ScxMapping(method={HttpMethod.POST})
    public DataJson signupByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType) {
        BaseUser newUser = ScxAuth.signupByThirdParty(uniqueID, accessToken, accountType);
        return DataJson.ok().data((Object)newUser);
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json logout(RoutingContext routingContext) {
        ScxAuth.removeAuthUser(routingContext);
        return Json.ok();
    }

    @Perms(checkPerms=false)
    @ScxMapping(method={HttpMethod.GET})
    public BaseVo info(RoutingContext routingContext) throws UnauthorizedException {
        Object user = ScxAuth.getLoginUser(routingContext);
        return DataJson.ok().data((Object)new UserInfo((BaseUser)((Object)user), ScxAuth.getPerms(user)));
    }

    @Perms(checkPerms=false)
    @ScxMapping(method={HttpMethod.POST})
    public DataJson changeUserAvatar(@FromBody String newAvatar) throws UnauthorizedException {
        Object loginUser = ScxAuth.getLoginUser();
        ((BaseUser)((Object)loginUser)).avatar = newAvatar;
        return DataJson.ok().data((Object)this.userService.update((BaseModel)loginUser, UpdateFilter.ofIncluded((String[])new String[]{"avatar"})));
    }

    @Perms(checkPerms=false)
    @ScxMapping(method={HttpMethod.POST})
    public BaseVo changeUserUsername(@FromBody String newUsername, @FromBody String password) throws UnauthorizedException {
        try {
            return DataJson.ok().data((Object)this.userService.changeUsernameBySelf(newUsername, password));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @Perms(checkPerms=false)
    @ScxMapping(method={HttpMethod.POST})
    public BaseVo changeUserPassword(@FromBody String newPassword, @FromBody String oldPassword) throws UnauthorizedException {
        try {
            return DataJson.ok().data((Object)this.userService.changePasswordBySelf(newPassword, oldPassword));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    public static class UserInfo {
        public final Long id;
        public final String username;
        public final Boolean isAdmin;
        public final String avatar;
        public final String phoneNumber;
        public final String emailAddress;
        public final String[] perms;
        public final String[] pagePerms;
        public final String[] pageElementPerms;
        public final boolean tombstone;

        public UserInfo(BaseUser user, PermsWrapper permsWrapper) {
            this.id = user.id;
            this.username = user.username;
            this.isAdmin = user.isAdmin;
            this.avatar = user.avatar;
            this.phoneNumber = user.phoneNumber;
            this.emailAddress = user.emailAddress;
            this.perms = (String[])permsWrapper.perms().toArray(String[]::new);
            this.pagePerms = (String[])permsWrapper.pagePerms().toArray(String[]::new);
            this.pageElementPerms = (String[])permsWrapper.pageElementPerms().toArray(String[]::new);
            this.tombstone = ScxContext.coreConfig().tombstone();
        }
    }
}

