/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.base;

import cool.scx.core.base.BaseModelService;
import cool.scx.ext.organization.base.BaseRole;
import cool.scx.ext.organization.base.BaseUser;
import cool.scx.ext.organization.base.UserRole;
import cool.scx.ext.organization.base.UserRoleService;
import cool.scx.sql.SQL;
import cool.scx.sql.base.Query;
import cool.scx.sql.base.SelectFilter;
import cool.scx.sql.where.WhereOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class BaseRoleService<T extends BaseRole>
extends BaseModelService<T> {
    private final UserRoleService userRoleService;

    public BaseRoleService(UserRoleService userRoleService) {
        this.userRoleService = userRoleService;
    }

    public List<T> getRoleListByUser(BaseUser user) {
        SQL roleIDs = this.userRoleService.buildListSQL(new Query().equal("userID", (Object)user.id, new WhereOption[0]), SelectFilter.ofIncluded((String[])new String[]{"roleID"}));
        return this.list(new Query().in("id", (Object)roleIDs, new WhereOption[0]));
    }

    public List<UserRole> getUserRoleByUserIDs(SQL userIDs) {
        return this.userRoleService.list(new Query().in("userID", (Object)userIDs, new WhereOption[0]));
    }

    public List<UserRole> findDeptByUserID(Long userID) {
        if (userID != null) {
            return this.userRoleService.list(new Query().equal("userID", (Object)userID, new WhereOption[0]));
        }
        return new ArrayList<UserRole>();
    }

    public void addRoleListWithUserID(Long userID, List<Long> roleIDs) {
        if (roleIDs != null) {
            List<UserRole> idArr = roleIDs.stream().filter(Objects::nonNull).map(id -> {
                UserRole userRole = new UserRole();
                userRole.userID = userID;
                userRole.roleID = id;
                return userRole;
            }).toList();
            this.userRoleService.add(idArr);
        }
    }

    public void deleteByUserID(Long id) {
        this.userRoleService.delete(new Query().equal("userID", (Object)id, new WhereOption[0]));
    }
}

