/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.base;

import cool.scx.core.base.BaseModelService;
import cool.scx.core.base.Query;
import cool.scx.core.base.SelectFilter;
import cool.scx.ext.organization.base.BaseDept;
import cool.scx.ext.organization.base.BaseUser;
import cool.scx.ext.organization.base.UserDept;
import cool.scx.ext.organization.base.UserDeptService;
import cool.scx.sql.SQL;
import cool.scx.sql.where.WhereOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public abstract class BaseDeptService<T extends BaseDept>
extends BaseModelService<T> {
    private final UserDeptService userDeptService;

    public BaseDeptService(UserDeptService userDeptService) {
        this.userDeptService = userDeptService;
    }

    public List<T> getDeptListByUser(BaseUser user) {
        SQL deptIDs = this.userDeptService.buildListSQL(new Query().equal("userID", (Object)user.id, new WhereOption[0]), SelectFilter.ofIncluded((String[])new String[]{"deptID"}));
        return this.list(new Query().in("id", (Object)deptIDs, new WhereOption[0]));
    }

    public void addDeptListWithUserID(Long userID, List<Long> deptIDs) {
        if (deptIDs != null) {
            List<UserDept> idArr = deptIDs.stream().filter(Objects::nonNull).map(id -> {
                UserDept userDept = new UserDept();
                userDept.userID = userID;
                userDept.deptID = id;
                return userDept;
            }).toList();
            this.userDeptService.add(idArr);
        }
    }

    public void deleteByUserID(Long id) {
        this.userDeptService.delete(new Query().equal("userID", (Object)id, new WhereOption[0]));
    }

    public List<UserDept> findDeptByUserID(Long userID) {
        if (userID != null) {
            return this.userDeptService.list(new Query().equal("userID", (Object)userID, new WhereOption[0]));
        }
        return new ArrayList<UserDept>();
    }

    public List<UserDept> getUserDeptByUserIDs(SQL userIDs) {
        return this.userDeptService.list(new Query().in("userID", (Object)userIDs, new WhereOption[0]));
    }

    public void deleteDeptWithChildren(Long id) {
        List<BaseDept> deptWithChildren = this.getDeptWithChildren(id);
        this.delete(deptWithChildren.stream().mapToLong(dept -> dept.id).toArray());
    }

    public List<BaseDept> getDeptWithChildren(Long id) {
        ArrayList<BaseDept> deptWithChildren = new ArrayList<BaseDept>();
        this._fillDeptWithChildren(deptWithChildren, (BaseDept)this.get(id));
        return deptWithChildren;
    }

    private void _fillDeptWithChildren(Collection<BaseDept> deptWithChildren, BaseDept parentDept) {
        if (parentDept != null) {
            deptWithChildren.add(parentDept);
            this.list(new Query().equal("parentID", (Object)parentDept.id, new WhereOption[0]), (SelectFilter)SelectFilter.ofIncluded().addIncluded(new String[]{"id"})).forEach(child -> this._fillDeptWithChildren(deptWithChildren, (BaseDept)((Object)child)));
        }
    }
}

