/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.base;

import cool.scx.core.ScxContext;
import cool.scx.core.base.BaseModel;
import cool.scx.core.base.BaseModelService;
import cool.scx.core.base.Query;
import cool.scx.core.base.SelectFilter;
import cool.scx.core.base.UpdateFilter;
import cool.scx.core.http.exception.impl.NoPermException;
import cool.scx.core.http.exception.impl.UnauthorizedException;
import cool.scx.ext.organization.auth.ScxAuth;
import cool.scx.ext.organization.base.BaseDeptService;
import cool.scx.ext.organization.base.BaseRoleService;
import cool.scx.ext.organization.base.BaseUser;
import cool.scx.ext.organization.base.UserDept;
import cool.scx.ext.organization.base.UserRole;
import cool.scx.ext.organization.exception.UnknownUserException;
import cool.scx.ext.organization.exception.UsernameAlreadyExistsException;
import cool.scx.ext.organization.exception.WrongPasswordException;
import cool.scx.sql.SQL;
import cool.scx.sql.where.WhereOption;
import cool.scx.util.CryptoUtils;
import cool.scx.util.MultiMap;
import cool.scx.util.NetUtils;
import cool.scx.util.StringUtils;
import io.vertx.core.http.HttpServerRequest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUserService<T extends BaseUser>
extends BaseModelService<T> {
    private static final Logger logger = LoggerFactory.getLogger(BaseUserService.class);
    private final BaseDeptService<?> deptService;
    private final BaseRoleService<?> roleService;

    public BaseUserService(BaseDeptService<?> deptService, BaseRoleService<?> roleService) {
        this.deptService = deptService;
        this.roleService = roleService;
    }

    public T addWithDeptAndRole(T user) {
        ((BaseUser)((Object)user)).password = this.encryptPassword(((BaseUser)((Object)user)).password);
        return (T)((Object)((BaseUser)((Object)this.autoTransaction(() -> {
            BaseUser newUser = (BaseUser)this.add((BaseModel)user);
            this.deptService.addDeptListWithUserID(newUser.id, user.deptIDs);
            this.roleService.addRoleListWithUserID(newUser.id, user.roleIDs);
            return (BaseUser)this.get(newUser.id);
        }))));
    }

    public T updateWithDeptAndRole(T user) {
        ((BaseUser)((Object)user)).password = this.encryptPassword(((BaseUser)((Object)user)).password);
        return (T)((Object)((BaseUser)((Object)this.autoTransaction(() -> {
            this.deptService.deleteByUserID(user.id);
            this.deptService.addDeptListWithUserID(user.id, user.deptIDs);
            this.roleService.deleteByUserID(user.id);
            this.roleService.addRoleListWithUserID(user.id, user.roleIDs);
            return (BaseUser)this.update((BaseModel)user);
        }))));
    }

    public boolean checkThatThereIsAtLeastOneAdmin(Long id) {
        long count = this.count(new Query().equal("isAdmin", (Object)true, new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[]{WhereOption.SKIP_IF_NULL}));
        return count != 0L;
    }

    public List<T> list(Query query, SelectFilter selectFilter) {
        return this.fillDeptIDsAndRoleIDsField(super.list(query, selectFilter), query);
    }

    public List<T> fillDeptIDsAndRoleIDsField(List<T> oldList, Query query) {
        SQL userIDs = this.buildListSQLWithAlias(query, SelectFilter.ofIncluded((String[])new String[]{"id"}));
        List<UserDept> userDeptList = this.deptService.getUserDeptByUserIDs(userIDs);
        List<UserRole> userRoleList = this.roleService.getUserRoleByUserIDs(userIDs);
        MultiMap userIDAndDeptIDMap = new MultiMap();
        MultiMap userIDAndRoleIDMap = new MultiMap();
        for (UserDept userDept : userDeptList) {
            userIDAndDeptIDMap.put((Object)userDept.userID, (Object)userDept.deptID);
        }
        for (UserRole userRole : userRoleList) {
            userIDAndRoleIDMap.put((Object)userRole.userID, (Object)userRole.roleID);
        }
        return oldList.stream().peek(item -> {
            item.deptIDs = userIDAndDeptIDMap.get((Object)item.id);
            item.roleIDs = userIDAndRoleIDMap.get((Object)item.id);
        }).toList();
    }

    public final T changePasswordByAdminUser(String newPassword, Long id) {
        this.checkNowLoginUserIsAdmin();
        T needChangeUser = this.checkNeedChangeUserByID(id);
        ((BaseUser)((Object)needChangeUser)).password = CryptoUtils.encryptPassword((String)this.checkNewPasswordStr(newPassword));
        return (T)((Object)((BaseUser)this.update((BaseModel)needChangeUser)));
    }

    public final BaseUser changePasswordBySelf(String newPassword, String password) {
        BaseUser loginUser = this.checkNowLoginUser();
        this.checkPassword(loginUser, password);
        T needChangeUser = this.checkNeedChangeUserByID(loginUser.id);
        ((BaseUser)((Object)needChangeUser)).password = CryptoUtils.encryptPassword((String)this.checkNewPasswordStr(newPassword));
        return (BaseUser)this.update((BaseModel)needChangeUser);
    }

    public final BaseUser changeUsernameBySelf(String newUsername, String password) {
        BaseUser loginUser = this.checkNowLoginUser();
        this.checkPassword(loginUser, password);
        T needChangeUser = this.checkNeedChangeUserByID(loginUser.id);
        ((BaseUser)((Object)needChangeUser)).username = this.checkNewUsernameStr(newUsername, ((BaseUser)((Object)needChangeUser)).id);
        return (BaseUser)this.update((BaseModel)needChangeUser);
    }

    public final T checkNeedChangeUserByID(Long id) {
        BaseUser needChangeUser = (BaseUser)this.get(id, (SelectFilter)SelectFilter.ofIncluded().addIncluded(new String[]{"id", "password", "username"}));
        if (needChangeUser == null) {
            throw new UnknownUserException();
        }
        return (T)((Object)needChangeUser);
    }

    public final String checkNewUsernameStr(String username, Long id) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("\u65b0\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        long count = this.count(new Query().equal("username", (Object)(username = username.trim()), new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[0]));
        if (count != 0L) {
            throw new UsernameAlreadyExistsException();
        }
        return username;
    }

    public final String checkNewUsernameStr(String username) {
        if (StringUtils.isBlank((String)username)) {
            throw new IllegalArgumentException("\u65b0\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        long count = this.count(new Query().equal("username", (Object)(username = username.trim()), new WhereOption[0]));
        if (count != 0L) {
            throw new UsernameAlreadyExistsException();
        }
        return username;
    }

    public final String checkNewPasswordStr(String password) {
        if (StringUtils.isBlank((String)password)) {
            throw new IllegalArgumentException("\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        return password.trim();
    }

    public final BaseUser checkNowLoginUserIsAdmin() {
        BaseUser loginUser = this.checkNowLoginUser();
        if (!loginUser.isAdmin.booleanValue()) {
            throw new NoPermException("\u975e\u7ba1\u7406\u5458\u65e0\u6743\u9650\u4fee\u6539\u7528\u6237\u7684\u7528\u6237\u540d !!!");
        }
        return loginUser;
    }

    public final BaseUser checkNowLoginUser() {
        Object loginUser = ScxAuth.getLoginUser();
        if (loginUser == null) {
            throw new UnauthorizedException("\u8bf7\u767b\u5f55 !!!");
        }
        return loginUser;
    }

    public final void checkPassword(BaseUser user, String password) {
        boolean b;
        try {
            b = CryptoUtils.checkPassword((String)password, (String)user.password);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u7528\u6237\u5bc6\u7801\u65f6\u51fa\u73b0\u89e3\u7801\u9519\u8bef !!!", (Throwable)e);
            throw new WrongPasswordException();
        }
        if (!b) {
            throw new WrongPasswordException();
        }
    }

    public BaseUser tryLogin(String username, String password) {
        BaseUser needLoginUser = (BaseUser)this.get(new Query().equal("username", (Object)username, new WhereOption[0]));
        if (needLoginUser == null) {
            throw new UnknownUserException();
        }
        this.checkPassword(needLoginUser, password);
        return needLoginUser;
    }

    public BaseUser tryLoginByEmailAddress(String emailAddress, String verificationCode) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u6b64\u79cd\u767b\u5f55\u65b9\u5f0f");
    }

    public BaseUser tryLoginByPhoneNumber(String phoneNumber, String verificationCode) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0\u6b64\u79cd\u767b\u5f55\u65b9\u5f0f");
    }

    public String encryptPassword(String plainPassword) {
        if (StringUtils.notBlank((String)plainPassword)) {
            return CryptoUtils.encryptPassword((String)plainPassword.trim());
        }
        return null;
    }

    public void updateLastLoginDateAndIP(BaseUser user, String accountType) {
        BaseUser oldUser = (BaseUser)this.get(user.id);
        List<BaseUser.LoginInfo> history = oldUser.loginInfoHistory;
        if (history == null) {
            history = new ArrayList<BaseUser.LoginInfo>();
        }
        String ip = NetUtils.getClientIPAddress((HttpServerRequest)ScxContext.routingContext().request());
        LocalDateTime date = LocalDateTime.now();
        history.add(new BaseUser.LoginInfo(ip, date, accountType));
        oldUser.loginInfoHistory = history.subList(Math.max(history.size() - 10, 0), history.size());
        this.update(oldUser, new Query().equal("id", (Object)oldUser.id, new WhereOption[0]), UpdateFilter.ofIncluded((String[])new String[]{"loginInfoHistory"}));
    }

    public T signup(T user) {
        ((BaseUser)((Object)user)).username = this.checkNewUsernameStr(((BaseUser)((Object)user)).username);
        ((BaseUser)((Object)user)).password = CryptoUtils.encryptPassword((String)this.checkNewPasswordStr(((BaseUser)((Object)user)).password));
        ((BaseUser)((Object)user)).isAdmin = false;
        return (T)((Object)((BaseUser)this.add((BaseModel)user)));
    }
}

