/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.core.http.exception.BadRequestException;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptySelectColumnException;
import cool.scx.ext.crud.exception.PaginationParametersErrorException;
import cool.scx.ext.crud.exception.UnknownFilterModeException;
import cool.scx.ext.crud.exception.UnknownSortTypeException;
import cool.scx.ext.crud.exception.UnknownWhereTypeException;
import cool.scx.ext.crud.exception.WhereBodyParametersSizeErrorException;
import cool.scx.sql.TableInfo;
import cool.scx.sql.base.ColumnInfoFilter;
import cool.scx.sql.base.Query;
import cool.scx.sql.base.SelectFilter;
import cool.scx.sql.order_by.OrderByOption;
import cool.scx.sql.order_by.OrderByType;
import cool.scx.sql.where.WhereOption;
import cool.scx.sql.where.WhereType;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class CRUDListParam {
    public CRUDPagination pagination;
    public List<CRUDOrderByBody> orderByBodyList;
    public List<CRUDWhereBody> whereBodyList;
    public CRUDSelectFilterBody selectFilterBody;

    public static WhereType checkWhereType(String fieldName, String strWhereType) throws UnknownWhereTypeException {
        try {
            return WhereType.of((String)strWhereType);
        }
        catch (Exception ignored) {
            throw new UnknownWhereTypeException(fieldName, strWhereType);
        }
    }

    public static OrderByType checkSortType(String fieldName, String strSortType) throws UnknownSortTypeException {
        try {
            return OrderByType.of((String)strSortType);
        }
        catch (Exception ignored) {
            throw new UnknownSortTypeException(fieldName, strSortType);
        }
    }

    public static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws WhereBodyParametersSizeErrorException {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new WhereBodyParametersSizeErrorException(fieldName, whereType, paramSize.get());
        }
    }

    public static ColumnInfoFilter.FilterMode checkFilterMode(String filterMode) throws UnknownWhereTypeException {
        try {
            return ColumnInfoFilter.FilterMode.of((String)filterMode);
        }
        catch (Exception ignored) {
            throw new UnknownFilterModeException(filterMode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkPagination(Query query, CRUDPagination crudPagination) {
        Integer pageSize = crudPagination.pageSize;
        Integer currentPage = crudPagination.currentPage;
        if (pageSize == null) return;
        if (pageSize < 0) throw new PaginationParametersErrorException(currentPage, pageSize);
        if (currentPage == null) {
            query.setPagination(pageSize);
            return;
        } else {
            if (currentPage < 0) throw new PaginationParametersErrorException(currentPage, pageSize);
            query.setPagination(currentPage, pageSize);
        }
    }

    public Query getQuery(Class<? extends BaseModel> modelClass) throws BadRequestException {
        Query query = new Query();
        if (this.pagination != null) {
            CRUDListParam.checkPagination(query, this.pagination);
        }
        if (this.orderByBodyList != null) {
            for (CRUDOrderByBody orderByBody : this.orderByBodyList) {
                if (orderByBody.fieldName == null || orderByBody.sortType == null) continue;
                CRUDHelper.checkFieldName(modelClass, orderByBody.fieldName);
                OrderByType sortType = CRUDListParam.checkSortType(orderByBody.fieldName, orderByBody.sortType);
                query.orderBy().add(orderByBody.fieldName, sortType, new OrderByOption[0]);
            }
        }
        if (this.whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : this.whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDListParam.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDListParam.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    query.where().add0(crudWhereBody.fieldName, whereType, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    query.where().add1(crudWhereBody.fieldName, whereType, crudWhereBody.value1, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                query.where().add2(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2, new WhereOption[0]);
            }
        }
        return query;
    }

    public SelectFilter getSelectFilter(Class<? extends BaseModel> modelClass, TableInfo scxDaoTableInfo) {
        SelectFilter selectFilter;
        if (this.selectFilterBody == null) {
            return SelectFilter.ofExcluded();
        }
        ColumnInfoFilter.FilterMode filterMode = CRUDListParam.checkFilterMode(this.selectFilterBody.filterMode);
        String[] legalFieldName = this.selectFilterBody.fieldNames != null ? (String[])Arrays.stream(this.selectFilterBody.fieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new) : new String[]{};
        switch (filterMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXCLUDED: {
                SelectFilter selectFilter2 = (SelectFilter)SelectFilter.ofExcluded().addExcluded(legalFieldName);
                break;
            }
            case INCLUDED: {
                SelectFilter selectFilter2 = selectFilter = (SelectFilter)SelectFilter.ofIncluded().addIncluded(legalFieldName);
            }
        }
        if (selectFilter.filter(scxDaoTableInfo.columnInfos()).length == 0) {
            throw new EmptySelectColumnException(filterMode, this.selectFilterBody.fieldNames);
        }
        return selectFilter;
    }

    public static final class CRUDPagination {
        public Integer currentPage;
        public Integer pageSize;
    }

    public static final class CRUDOrderByBody {
        public String fieldName;
        public String sortType;
    }

    public static final class CRUDWhereBody {
        public String fieldName;
        public String whereType;
        public Object value1;
        public Object value2;

        public CRUDWhereBody() {
        }

        public CRUDWhereBody(String fieldName, String whereType, Object value1, Object value2) {
            this.fieldName = fieldName;
            this.whereType = whereType;
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    public static final class CRUDSelectFilterBody {
        public String filterMode;
        public String[] fieldNames;
    }
}

