/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.base;

import cool.scx.core.annotation.FromBody;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.enumeration.HttpMethod;
import cool.scx.core.vo.BaseVo;
import cool.scx.core.vo.DataJson;
import cool.scx.core.vo.Json;
import cool.scx.ext.crud.CRUDUpdateParam;
import cool.scx.ext.organization.annotation.ApiPerms;
import cool.scx.ext.organization.base.BaseUser;
import cool.scx.ext.organization.base.BaseUserService;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class BaseUserController<T extends BaseUser> {
    protected final Class<T> entityClass;
    private final BaseUserService<T> userService;

    public BaseUserController(BaseUserService<T> userService) {
        this.userService = userService;
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            throw new IllegalArgumentException(this.getClass().getName() + " : \u5fc5\u987b\u8bbe\u7f6e\u6cdb\u578b\u53c2\u6570 !!!");
        }
        Type[] typeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        this.entityClass = (Class)typeArguments[0];
    }

    @ScxMapping(useNameAsUrl=false, method={HttpMethod.POST})
    public BaseVo add(@FromBody(useAllBody=true) T user) {
        this.userService.checkNowLoginUserIsAdmin();
        return DataJson.ok().data(this.userService.addWithDeptAndRole(user));
    }

    @ScxMapping(value="/", method={HttpMethod.PUT})
    public BaseVo update(CRUDUpdateParam crudUpdateParam) {
        BaseUser user = (BaseUser)((Object)crudUpdateParam.getBaseModel(this.entityClass));
        this.userService.checkNowLoginUserIsAdmin();
        return DataJson.ok().data((Object)this.userService.updateWithDeptAndRole(user));
    }

    @ScxMapping(method={HttpMethod.POST})
    public BaseVo checkThatThereIsAtLeastOneAdmin(@FromBody(required=false) Long id) {
        return this.userService.checkThatThereIsAtLeastOneAdmin(id) ? Json.ok() : Json.fail();
    }

    @ApiPerms
    @ScxMapping(method={HttpMethod.PUT})
    public BaseVo changePasswordByAdminUser(@FromBody String newPassword, @FromBody Long userID) {
        return DataJson.ok().data(this.userService.changePasswordByAdminUser(newPassword, userID));
    }

    @ApiPerms
    @ScxMapping(method={HttpMethod.PUT})
    public BaseVo changeUsernameBySelf(@FromBody String newUsername, @FromBody String password) {
        return DataJson.ok().data((Object)this.userService.changeUsernameBySelf(newUsername, password));
    }

    @ApiPerms
    @ScxMapping(method={HttpMethod.PUT})
    public BaseVo changePasswordBySelf(@FromBody String newPassword, @FromBody String password) {
        return DataJson.ok().data((Object)this.userService.changePasswordBySelf(newPassword, password));
    }
}

