/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.core.ScxContext;
import cool.scx.core.mvc.ScxMappingInterceptor;
import cool.scx.ext.organization.auth.DeviceType;
import cool.scx.ext.organization.auth.LoggedInClient;
import cool.scx.ext.organization.auth.LoggedInClientTable;
import cool.scx.ext.organization.auth.PermFlag;
import cool.scx.ext.organization.auth.PermsAnnotationInterceptor;
import cool.scx.ext.organization.auth.PermsWrapper;
import cool.scx.ext.organization.auth.ScxAuthCookieHandler;
import cool.scx.ext.organization.auth.ThirdPartyLoginHandler;
import cool.scx.ext.organization.base.BaseDeptService;
import cool.scx.ext.organization.base.BaseRoleService;
import cool.scx.ext.organization.base.BaseUser;
import cool.scx.ext.organization.base.BaseUserService;
import cool.scx.ext.organization.base.PermsModel;
import cool.scx.ext.organization.exception.AuthException;
import cool.scx.ext.organization.exception.UnknownDeviceException;
import cool.scx.ext.organization.exception.UnknownLoginHandlerException;
import cool.scx.ext.ws.WSContext;
import cool.scx.ext.ws.WSMessage;
import cool.scx.sql.base.Query;
import cool.scx.sql.where.WhereOption;
import cool.scx.util.ObjectUtils;
import cool.scx.util.RandomUtils;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class ScxAuth {
    static final String SCX_AUTH_TOKEN_KEY = "S-Token";
    static final String SCX_AUTH_DEVICE_KEY = "S-Device";
    private static final LoggedInClientTable LOGGED_IN_CLIENT_TABLE = new LoggedInClientTable();
    private static final Path SCX_SESSION_CACHE_PATH = ScxContext.getPathByAppRoot((String)"AppRoot:scx-session.cache");
    private static final Map<String, ThirdPartyLoginHandler<?>> THIRD_PARTY_LOGIN_HANDLER_MAP = new HashMap();
    private static BaseUserService<?> userService;
    private static BaseRoleService<?> roleService;
    private static BaseDeptService<?> deptService;

    public static void initAuth(Class<? extends BaseUserService<?>> userServiceClass, Class<? extends BaseDeptService<?>> deptServiceClass, Class<? extends BaseRoleService<?>> roleServiceClass) {
        WSContext.wsConsumer("bind-websocket-by-token", ScxAuth::bindWebSocketByToken);
        ScxContext.scxMappingConfiguration().setScxMappingInterceptor((ScxMappingInterceptor)new PermsAnnotationInterceptor());
        ScxContext.router().corsHandler().allowedHeader(SCX_AUTH_TOKEN_KEY).allowedHeader(SCX_AUTH_DEVICE_KEY);
        ScxContext.router().vertxRouter().route().order(1).handler((Handler)new ScxAuthCookieHandler());
        userService = (BaseUserService)((Object)ScxContext.getBean(userServiceClass));
        roleService = (BaseRoleService)((Object)ScxContext.getBean(roleServiceClass));
        deptService = (BaseDeptService)((Object)ScxContext.getBean(deptServiceClass));
    }

    public static <T extends BaseUser> T getLoginUser() {
        return ScxAuth.getLoginUser(ScxContext.routingContext());
    }

    public static PermsWrapper getPerms() {
        return ScxAuth.getPerms(ScxAuth.getLoginUser());
    }

    public static void readSessionFromFile() {
        try (InputStream f = Files.newInputStream(SCX_SESSION_CACHE_PATH, new OpenOption[0]);){
            List clients = (List)ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readValue(f, (TypeReference)new TypeReference<List<LoggedInClient>>(){});
            LOGGED_IN_CLIENT_TABLE.addAll(clients);
            Ansi.out().brightGreen((Object)("\u6210\u529f\u4ece " + SCX_SESSION_CACHE_PATH + " \u4e2d\u6062\u590d " + clients.size() + " \u6761\u6570\u636e!!!"), new AnsiElement[0]).println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeSessionToFile() {
        try (OutputStream f = Files.newOutputStream(SCX_SESSION_CACHE_PATH, new OpenOption[0]);){
            f.write(ObjectUtils.toJson(LOGGED_IN_CLIENT_TABLE.loggedInClients(), (ObjectUtils.Option[])new ObjectUtils.Option[0]).getBytes(StandardCharsets.UTF_8));
            Ansi.out().red((Object)("\u4fdd\u5b58 Session \u5230 " + SCX_SESSION_CACHE_PATH + " \u4e2d!!!"), new AnsiElement[0]).println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static <T extends BaseUser> T getLoginUser(RoutingContext ctx) {
        return ScxAuth.getLoginUserByToken(ScxAuth.getToken(ctx));
    }

    public static <T extends BaseUser> T getLoginUserByWebSocketID(String webSocketID) {
        LoggedInClient client = LOGGED_IN_CLIENT_TABLE.getByWebSocketID(webSocketID);
        return (T)((Object)(client != null ? (BaseUser)userService.get(client.userID) : null));
    }

    public static <T extends BaseUser> T getLoginUserByWebSocket(ServerWebSocket socket) {
        LoggedInClient client = LOGGED_IN_CLIENT_TABLE.getByWebSocket(socket);
        return (T)((Object)(client != null ? (BaseUser)userService.get(client.userID) : null));
    }

    static void addLoginItem(String token, BaseUser authUser, DeviceType loginDevice) {
        LoggedInClient client = new LoggedInClient();
        client.token = token;
        client.userID = authUser.id;
        client.loginDevice = loginDevice;
        LOGGED_IN_CLIENT_TABLE.add(client);
    }

    public static <T extends BaseUser> T getLoginUserByToken(String token) {
        LoggedInClient client = LOGGED_IN_CLIENT_TABLE.getByToken(token);
        return (T)((Object)(client != null ? (BaseUser)userService.get(client.userID) : null));
    }

    public static LoggedInClient getLoggedInClient() {
        return LOGGED_IN_CLIENT_TABLE.getByToken(ScxAuth.getToken(ScxContext.routingContext()));
    }

    static String getTokenFromCookie(RoutingContext routingContext) {
        Cookie cookie = routingContext.request().getCookie(SCX_AUTH_TOKEN_KEY);
        return cookie != null ? cookie.getValue() : null;
    }

    static String getTokenFromHeader(RoutingContext routingContext) {
        return routingContext.request().getHeader(SCX_AUTH_TOKEN_KEY);
    }

    public static DeviceType getDeviceTypeByHeader(RoutingContext routingContext) {
        String device = routingContext.request().getHeader(SCX_AUTH_DEVICE_KEY);
        if (device == null) {
            return DeviceType.WEBSITE;
        }
        return DeviceType.of(device);
    }

    private static String getToken(RoutingContext ctx) {
        DeviceType device = ScxAuth.getDeviceTypeByHeader(ctx);
        return switch (device) {
            case DeviceType.WEBSITE -> ScxAuth.getTokenFromCookie(ctx);
            case DeviceType.ADMIN, DeviceType.APPLE, DeviceType.ANDROID -> ScxAuth.getTokenFromHeader(ctx);
            default -> null;
        };
    }

    public static void removeAuthUser(RoutingContext ctx) {
        LOGGED_IN_CLIENT_TABLE.removeByToken(ScxAuth.getToken(ctx));
    }

    private static void bindWebSocketByToken(WSMessage<?> wsParam) {
        Map objectMap = (Map)ObjectUtils.convertValue(wsParam.body(), (TypeReference)ObjectUtils.MAP_TYPE, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        String token = (String)ObjectUtils.convertValue(objectMap.get("token"), String.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        LoggedInClient client = LOGGED_IN_CLIENT_TABLE.getByToken(token);
        if (client != null) {
            client.webSocketID = wsParam.webSocket().binaryHandlerID();
        }
    }

    public static List<LoggedInClient> loggedInClients() {
        return LOGGED_IN_CLIENT_TABLE.loggedInClients();
    }

    public static PermsWrapper getPerms(BaseUser user) {
        ArrayList permissionModelList = new ArrayList();
        permissionModelList.addAll(deptService.getDeptListByUser(user));
        permissionModelList.addAll(roleService.getRoleListByUser(user));
        HashSet<String> pageElementPerms = new HashSet<String>();
        HashSet<String> pagePerms = new HashSet<String>();
        HashSet<String> perms = new HashSet<String>();
        HashSet<String> apiPerms = new HashSet<String>();
        for (PermsModel p : permissionModelList) {
            if (p.pagePerms != null) {
                pagePerms.addAll(p.pagePerms);
            }
            if (p.pageElementPerms != null) {
                pageElementPerms.addAll(p.pageElementPerms);
            }
            if (p.perms != null) {
                perms.addAll(p.perms);
            }
            if (p.apiPerms == null) continue;
            apiPerms.addAll(p.apiPerms);
        }
        return new PermsWrapper(perms, pagePerms, pageElementPerms, apiPerms);
    }

    public static boolean hasPerm(String permString) {
        Object loginUser = ScxAuth.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        if (((BaseUser)((Object)loginUser)).isAdmin.booleanValue()) {
            return true;
        }
        boolean deptHasPerm = false;
        boolean roleHasPerm = false;
        if (((BaseUser)((Object)loginUser)).deptIDs != null && ((BaseUser)((Object)loginUser)).deptIDs.size() > 0) {
            boolean bl = deptHasPerm = deptService.count(new Query().in("id", ((BaseUser)((Object)loginUser)).deptIDs, new WhereOption[0]).jsonContains("perms", (Object)permString, new WhereOption[0])) > 0L;
        }
        if (((BaseUser)((Object)loginUser)).roleIDs != null && ((BaseUser)((Object)loginUser)).roleIDs.size() > 0) {
            roleHasPerm = roleService.count(new Query().in("id", ((BaseUser)((Object)loginUser)).roleIDs, new WhereOption[0]).jsonContains("perms", (Object)permString, new WhereOption[0])) > 0L;
        }
        return deptHasPerm || roleHasPerm;
    }

    public static boolean hasPerm(PermFlag permFlag) {
        return ScxAuth.hasPerm(permFlag.permString());
    }

    private static String tryGetAuthToken(RoutingContext ctx, DeviceType loginDevice) throws AuthException {
        return switch (loginDevice) {
            default -> throw new IncompatibleClassChangeError();
            case DeviceType.ADMIN, DeviceType.APPLE, DeviceType.ANDROID -> RandomUtils.randomUUID();
            case DeviceType.WEBSITE -> ScxAuth.getTokenFromCookie(ctx);
            case DeviceType.UNKNOWN -> throw new UnknownDeviceException();
        };
    }

    public static String login(String username, String password, RoutingContext ctx) {
        DeviceType loginDevice = ScxAuth.getDeviceTypeByHeader(ctx);
        String token = ScxAuth.tryGetAuthToken(ctx, loginDevice);
        BaseUser loginUser = userService.tryLogin(username, password);
        ScxAuth.addLoginItem(token, loginUser, loginDevice);
        userService.updateLastLoginDateAndIP(loginUser, "PASSWORD");
        return token;
    }

    public static String loginByThirdParty(String uniqueID, String accessToken, String accountType, RoutingContext ctx) {
        DeviceType loginDevice = ScxAuth.getDeviceTypeByHeader(ctx);
        String token = ScxAuth.tryGetAuthToken(ctx, loginDevice);
        Object loginUser = ScxAuth.findThirdPartyLoginHandler(accountType).tryLogin(uniqueID, accessToken);
        ScxAuth.addLoginItem(token, loginUser, loginDevice);
        userService.updateLastLoginDateAndIP((BaseUser)((Object)loginUser), accountType);
        return token;
    }

    public static BaseUser signupByThirdParty(String uniqueID, String accessToken, String accountType) {
        BaseUser defaultNewUser = new BaseUser();
        defaultNewUser.username = "scx_" + RandomUtils.randomString((int)8, (boolean)true);
        defaultNewUser.isAdmin = false;
        ThirdPartyLoginHandler<?> handler = ScxAuth.findThirdPartyLoginHandler(accountType);
        return handler.signup(uniqueID, accessToken, defaultNewUser);
    }

    public static ThirdPartyLoginHandler<?> findThirdPartyLoginHandler(String type) {
        ThirdPartyLoginHandler<?> thirdPartyLoginHandler = THIRD_PARTY_LOGIN_HANDLER_MAP.get(type);
        if (thirdPartyLoginHandler == null) {
            throw new UnknownLoginHandlerException();
        }
        return thirdPartyLoginHandler;
    }

    public static void addThirdPartyLoginHandler(String type, ThirdPartyLoginHandler<?> thirdPartyLoginHandler) {
        THIRD_PARTY_LOGIN_HANDLER_MAP.put(type, thirdPartyLoginHandler);
    }

    public static LoggedInClientTable loggedInClientTable() {
        return LOGGED_IN_CLIENT_TABLE;
    }
}

