/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.core.http.exception.NoPermException;
import cool.scx.core.http.exception.UnauthorizedException;
import cool.scx.core.mvc.ScxMappingHandler;
import cool.scx.core.mvc.ScxMappingInterceptor;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.BaseUser;
import cool.scx.ext.auth.annotation.ApiPerms;
import cool.scx.util.StringUtils;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ApiPermsInterceptor
implements ScxMappingInterceptor {
    private final BaseAuthHandler<BaseUser> authHandler;
    private final Map<ScxMappingHandler, AuthPerms> SCX_AUTH_PERMS_CACHE = new HashMap<ScxMappingHandler, AuthPerms>();

    public ApiPermsInterceptor(BaseAuthHandler<BaseUser> authHandler) {
        this.authHandler = authHandler;
    }

    public void preHandle(RoutingContext context, ScxMappingHandler scxMappingHandler) {
        AuthPerms p = this.getScxAuthPerms(scxMappingHandler);
        if (p.needCheckPerms) {
            BaseUser currentUser = this.authHandler.getCurrentUser(context);
            if (currentUser == null) {
                throw new UnauthorizedException();
            }
            if (p.checkPerms && !currentUser.isAdmin.booleanValue() && !this.authHandler.getPerms(currentUser).apiPerms().contains(p.permStr)) {
                throw new NoPermException();
            }
        }
    }

    private AuthPerms getScxAuthPerms(ScxMappingHandler s) {
        AuthPerms p = this.SCX_AUTH_PERMS_CACHE.get(s);
        if (p == null) {
            p = new AuthPerms(s.clazz, s.method);
            this.SCX_AUTH_PERMS_CACHE.put(s, p);
        }
        return p;
    }

    private static final class AuthPerms {
        public final String permStr;
        public final boolean needCheckPerms;
        public final boolean checkPerms;

        public AuthPerms(Class<?> clazz, Method method) {
            String defaultPermStr = clazz.getSimpleName() + ":" + method.getName();
            ApiPerms scxPerms = method.getAnnotation(ApiPerms.class);
            if (scxPerms != null) {
                this.permStr = StringUtils.notBlank((String)scxPerms.value()) ? scxPerms.value() : defaultPermStr;
                this.checkPerms = scxPerms.checkPerms();
                this.needCheckPerms = true;
            } else {
                this.permStr = defaultPermStr;
                this.checkPerms = false;
                this.needCheckPerms = false;
            }
        }
    }
}

