/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.core.ScxContext;
import cool.scx.core.ScxModule;
import cool.scx.core.mvc.ScxMappingInterceptor;
import cool.scx.ext.auth.ApiPermsInterceptor;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.ScxAuthCookieHandler;
import cool.scx.ext.ws.WSContext;
import io.vertx.core.Handler;

public class AuthModule
extends ScxModule {
    public static void init() {
        BaseAuthHandler authHandler = (BaseAuthHandler)ScxContext.getBean(BaseAuthHandler.class);
        WSContext.wsConsumer("bind-websocket-by-token", authHandler::bindWebSocketByToken);
        ScxContext.scxMappingConfiguration().setScxMappingInterceptor((ScxMappingInterceptor)new ApiPermsInterceptor(authHandler));
        ScxContext.router().corsHandler().allowedHeader("S-Token").allowedHeader("S-Device");
        ScxContext.router().vertxRouter().route().order(1).handler((Handler)new ScxAuthCookieHandler());
    }

    public void start() {
        AuthModule.init();
        ((BaseAuthHandler)ScxContext.getBean(BaseAuthHandler.class)).readSessionFromFile();
    }

    public void stop() {
        ((BaseAuthHandler)ScxContext.getBean(BaseAuthHandler.class)).writeSessionToFile();
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }
}

