/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.cms.template;

import cool.scx.core.ScxContext;
import cool.scx.core.annotation.FromUpload;
import cool.scx.core.type.UploadedEntity;
import cool.scx.core.vo.Json;
import cool.scx.ext.cms.template.TemplateInfo;
import cool.scx.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public final class TemplateHelper {
    private static List<TemplateInfo> getTemplateList(String filePath) throws IOException {
        final LinkedList<TemplateInfo> fileList = new LinkedList<TemplateInfo>();
        final Path path = Paths.get(filePath, new String[0]);
        Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                TemplateInfo fileInfo = new TemplateInfo();
                fileInfo.type = "Directory";
                TemplateHelper.getFileVisitResult(dir, fileInfo, path, fileList);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                TemplateInfo fileInfo = new TemplateInfo();
                fileInfo.type = "File";
                TemplateHelper.getFileVisitResult(file, fileInfo, path, fileList);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        return fileList;
    }

    private static void getFileVisitResult(Path file, TemplateInfo templateInfo, Path path, LinkedList<TemplateInfo> fileList) {
        templateInfo.id = file.getFileName().toString();
        templateInfo.parentID = file.getParent().toFile().getPath();
        templateInfo.parentID = path.toString().equals(templateInfo.parentID) ? "0" : file.getParent().getFileName().toString();
        templateInfo.filePath = file.toFile().getPath();
        fileList.add(templateInfo);
    }

    private static boolean checkPath(String path) {
        return path.startsWith(ScxContext.coreConfig().templateRoot().toString());
    }

    public static Json index() throws IOException {
        List<TemplateInfo> allTemplateList = TemplateHelper.getTemplateList(ScxContext.coreConfig().templateRoot().toString());
        List directoryList = allTemplateList.stream().filter(templateInfo -> "Directory".equals(templateInfo.type)).collect(Collectors.toList());
        List<TemplateInfo> fileList = allTemplateList.stream().filter(templateInfo -> "File".equals(templateInfo.type)).toList();
        directoryList.addAll(fileList);
        return Json.ok().put("cmsRootTreeList", directoryList);
    }

    public static Json getFileContent(String filePath) {
        try {
            boolean b = TemplateHelper.checkPath(filePath);
            if (b) {
                String fileContent = Files.readString(Paths.get(filePath, new String[0]));
                return Json.ok().put("fileContent", (Object)fileContent);
            }
            return Json.ok().put("fileContent", (Object)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
        }
        catch (Exception exception) {
            return Json.ok().put("fileContent", (Object)"\u6b64\u6587\u4ef6\u65e0\u6cd5\u7f16\u8f91");
        }
    }

    public static Json setFileContent(String filePath, String fileContent) throws IOException {
        boolean b = TemplateHelper.checkPath(filePath);
        if (b) {
            Files.writeString(Path.of(filePath, new String[0]), (CharSequence)fileContent, new OpenOption[0]);
            return TemplateHelper.getFileContent(filePath);
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }

    public static Json delete(String filePath) throws IOException {
        boolean b = TemplateHelper.checkPath(filePath);
        if (b) {
            FileUtils.delete((Path)Path.of(filePath, new String[0]), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
            return Json.ok();
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }

    public static Json upload(@FromUpload UploadedEntity file, String filePath) throws IOException {
        if (TemplateHelper.checkPath(filePath)) {
            FileUtils.write((Path)Path.of(filePath, file.fileName()), (byte[])file.buffer().getBytes(), (OpenOption[])new OpenOption[0]);
            return Json.ok();
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }

    public static Json rename(String newFilePath, String oldFilePath) {
        boolean b = TemplateHelper.checkPath(newFilePath);
        boolean b1 = TemplateHelper.checkPath(oldFilePath);
        if (b && b1) {
            Path path = Paths.get(oldFilePath, new String[0]);
            String parent = path.getParent().toFile().getPath();
            boolean b2 = path.toFile().renameTo(new File(parent + "\\" + newFilePath));
            return b2 ? Json.ok() : Json.fail();
        }
        return Json.fail((String)"\u6587\u4ef6\u65e0\u6cd5\u8bbf\u95ee");
    }
}

