/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.config_manager;

import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.core.annotation.ScxMapping;
import cool.scx.core.annotation.ScxWebSocketMapping;
import cool.scx.core.base.BaseWebSocketHandler;
import cool.scx.core.enumeration.HttpMethod;
import cool.scx.core.vo.Json;
import cool.scx.core.websocket.OnOpenRoutingContext;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.BaseUser;
import cool.scx.ext.auth.LoggedInClient;
import cool.scx.ext.auth.annotation.ApiPerms;
import cool.scx.ext.config_manager.BaseConfigManager;
import cool.scx.ext.config_manager.BaseSystemConfig;
import cool.scx.ext.config_manager.BaseUserConfig;
import cool.scx.ext.ws.WSContext;
import cool.scx.util.ObjectUtils;
import io.vertx.core.http.ServerWebSocket;
import java.util.List;
import java.util.Map;

@ScxMapping(value="api")
@ScxWebSocketMapping(value="/scx", order=1)
public class ConfigManagerApi<S extends BaseSystemConfig, U extends BaseUserConfig>
implements BaseWebSocketHandler {
    public static final String ON_SCX_USER_CONFIG_CHANGE_EVENT_NAME = "onScxUserConfigChange";
    public static final String ON_SCX_SYSTEM_CONFIG_CHANGE_EVENT_NAME = "onScxSystemConfigChange";
    protected final BaseConfigManager<S, U> configManager;
    protected final BaseAuthHandler<?> authHandler;
    private final Class<S> systemConfigClass;
    private final Class<U> userConfigClass;

    public ConfigManagerApi(BaseConfigManager<S, U> configManager, BaseAuthHandler<?> authHandler) {
        this.configManager = configManager;
        this.authHandler = authHandler;
        this.systemConfigClass = configManager.getSystemConfigService()._baseDao()._entityClass();
        this.userConfigClass = configManager.getUserConfigService()._baseDao()._entityClass();
        this.initHandler();
    }

    @ApiPerms
    @ScxMapping(value="system-config", method={HttpMethod.PUT})
    public Json updateSystemConfig(Map<String, Object> config) {
        BaseSystemConfig systemConfig = (BaseSystemConfig)((Object)ObjectUtils.convertValue(config, this.systemConfigClass, (ObjectUtils.Option[])new ObjectUtils.Option[0]));
        BaseSystemConfig newConfig = this.configManager.updateSystemConfig(systemConfig);
        WSContext.wsPublishAll(ON_SCX_SYSTEM_CONFIG_CHANGE_EVENT_NAME, (Object)newConfig);
        return Json.ok();
    }

    @ApiPerms(checkPerms=false)
    @ScxMapping(value="user-config", method={HttpMethod.PUT})
    public Json updateUserConfig(Map<String, Object> config) {
        Object user = this.authHandler.getCurrentUser();
        BaseUserConfig userConfig = (BaseUserConfig)((Object)ObjectUtils.convertValue(config, this.userConfigClass, (ObjectUtils.Option[])new ObjectUtils.Option[0]));
        BaseUserConfig newConfig = this.configManager.updateUserConfig(((BaseUser)((Object)user)).id, userConfig);
        List<ServerWebSocket> allWebSocket = this.authHandler.loggedInClientTable().getByUserID(((BaseUser)((Object)user)).id).stream().map(c -> WSContext.getOnlineClient(c.webSocketID)).toList();
        WSContext.wsPublish(ON_SCX_USER_CONFIG_CHANGE_EVENT_NAME, (Object)newConfig, allWebSocket);
        return Json.ok();
    }

    public void initHandler() {
        WSContext.wsConsumer("bind-websocket-by-token", wsParam -> {
            ServerWebSocket webSocket = wsParam.webSocket();
            Map objectMap = (Map)ObjectUtils.convertValue(wsParam.body(), (TypeReference)ObjectUtils.MAP_TYPE, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
            String token = (String)ObjectUtils.convertValue(objectMap.get("token"), String.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
            LoggedInClient client = this.authHandler.loggedInClientTable().getByToken(token);
            if (client != null) {
                WSContext.wsPublish(ON_SCX_USER_CONFIG_CHANGE_EVENT_NAME, this.configManager.getUserConfig(client.userID), webSocket);
            }
        });
    }

    public void onOpen(ServerWebSocket webSocket, OnOpenRoutingContext context) {
        WSContext.wsPublish(ON_SCX_SYSTEM_CONFIG_CHANGE_EVENT_NAME, this.configManager.getSystemConfig(), webSocket);
    }
}

