/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.redirects;

import cool.scx.core.ScxContext;
import cool.scx.core.ScxModule;
import cool.scx.core.vo.Redirections;
import cool.scx.util.ansi.Ansi;
import cool.scx.util.ansi.AnsiElement;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;

public class RedirectsModule
extends ScxModule {
    private final int port;

    public RedirectsModule() {
        this(80);
    }

    public RedirectsModule(int port) {
        this.port = port;
    }

    public static void startRedirects(Vertx vertx, int port) {
        Router router = Router.router((Vertx)vertx);
        router.route().handler(c -> {
            String oldURI = c.request().absoluteURI();
            String newURI = "https" + oldURI.substring("http".length());
            Redirections.ofTemporary((String)newURI).handle(c);
        });
        vertx.createHttpServer().requestHandler((Handler)router).listen(port, http -> {
            if (http.succeeded()) {
                Ansi.out().brightMagenta((Object)("\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f http -> https, \u7aef\u53e3\u53f7 : " + port + " !!!"), new AnsiElement[0]).println();
            } else {
                http.cause().printStackTrace();
            }
        });
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }

    public void start() {
        if (ScxContext.coreConfig().isHttpsEnabled()) {
            RedirectsModule.startRedirects(ScxContext.vertx(), this.port);
        }
    }
}

