/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.organization.auth;

import cool.scx.Scx;
import cool.scx.ScxContext;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.ScxMapping;
import cool.scx.bo.Query;
import cool.scx.bo.Where;
import cool.scx.enumeration.HttpMethod;
import cool.scx.exception.UnauthorizedException;
import cool.scx.ext.organization.OrganizationConfig;
import cool.scx.ext.organization.User;
import cool.scx.ext.organization.UserService;
import cool.scx.ext.organization.auth.OrganizationAuth;
import cool.scx.ext.organization.auth.OrganizationAuthDeviceType;
import cool.scx.ext.organization.auth.OrganizationLoginException;
import cool.scx.ext.organization.auth.UnknownDeviceException;
import cool.scx.ext.organization.auth.UnknownUserException;
import cool.scx.ext.organization.auth.WrongPasswordException;
import cool.scx.util.CryptoUtils;
import cool.scx.util.NetUtils;
import cool.scx.util.RandomUtils;
import cool.scx.vo.Json;
import io.vertx.ext.web.RoutingContext;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;

@ScxMapping(value="/api/auth")
public class OrganizationAuthController {
    private final UserService userService;

    public OrganizationAuthController(UserService userService) {
        this.userService = userService;
    }

    private static String tryGetAuthToken(RoutingContext ctx, OrganizationAuthDeviceType loginDevice) throws OrganizationLoginException {
        return switch (loginDevice) {
            default -> throw new IncompatibleClassChangeError();
            case OrganizationAuthDeviceType.ADMIN, OrganizationAuthDeviceType.ANDROID, OrganizationAuthDeviceType.APPLE -> RandomUtils.getUUID();
            case OrganizationAuthDeviceType.WEBSITE -> OrganizationAuth.getTokenByCookie(ctx);
            case OrganizationAuthDeviceType.UNKNOWN -> throw new UnknownDeviceException();
        };
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json login(@FromBody String username, @FromBody String password, RoutingContext ctx) throws SQLException {
        try {
            OrganizationAuthDeviceType loginDevice = OrganizationAuth.getDeviceTypeByHeader(ctx);
            String token = OrganizationAuthController.tryGetAuthToken(ctx, loginDevice);
            User loginUser = this.tryLogin(username, password);
            OrganizationAuth.addLoginItem(token, loginUser, loginDevice);
            this.updateLastLoginDateAndIP(loginUser.id);
            if (loginDevice == OrganizationAuthDeviceType.WEBSITE) {
                return Json.fail((String)"login-successful");
            }
            return Json.ok().put("token", (Object)token);
        }
        catch (OrganizationLoginException organizationLoginException) {
            if (organizationLoginException instanceof UnknownDeviceException) {
                return Json.fail((String)"\u672a\u77e5\u8bbe\u5907");
            }
            if (organizationLoginException instanceof UnknownUserException) {
                return Json.fail((String)(OrganizationConfig.confusionLoginError() ? "usernameOrPasswordError" : "userNotFound"));
            }
            if (organizationLoginException instanceof WrongPasswordException) {
                return Json.fail((String)(OrganizationConfig.confusionLoginError() ? "usernameOrPasswordError" : "passwordError"));
            }
            System.err.println("\u767b\u5f55\u51fa\u9519 : " + organizationLoginException.getMessage());
            return Json.fail((String)"logonFailure");
        }
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json signup(String username, String password) throws SQLException {
        if (this.userService.get(new Query().equal("username", (Object)username)) != null) {
            return Json.fail((String)"userAlreadyExists");
        }
        User user = new User();
        user.username = username;
        user.password = CryptoUtils.encryptPassword((String)password);
        user.isAdmin = false;
        return this.userService.save(user) != null ? Json.ok() : Json.fail((String)"signup-error");
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json logout() {
        boolean b = OrganizationAuth.removeAuthUser(ScxContext.routingContext());
        System.err.println("\u5f53\u524d\u603b\u767b\u5f55\u7528\u6237\u6570\u91cf : " + OrganizationAuth.getAllLoginItem().size() + " \u4e2a");
        return b ? Json.ok() : Json.fail();
    }

    @ScxMapping(method={HttpMethod.GET})
    public Json info() throws UnauthorizedException {
        User user = OrganizationAuth.getLoginUser(ScxContext.routingContext());
        if (user == null) {
            throw new UnauthorizedException();
        }
        return Json.ok().put("id", (Object)user.id).put("username", (Object)user.username).put("nickname", (Object)user.nickname).put("avatar", (Object)user.avatar).put("perms", OrganizationAuth.getPerms(user)).put("tombstone", (Object)Scx.easyConfig().tombstone());
    }

    private User tryLogin(String username, String password) throws OrganizationLoginException, SQLException {
        User user = (User)this.userService.get(new Query().equal("username", (Object)username));
        if (user == null) {
            throw new UnknownUserException();
        }
        if (!CryptoUtils.checkPassword((String)password, (String)user.password)) {
            throw new WrongPasswordException();
        }
        return user;
    }

    private void updateLastLoginDateAndIP(Long userID) throws SQLException {
        User oldUser = (User)this.userService.get(userID);
        if (oldUser.lastLoginIPList == null) {
            oldUser.lastLoginIPList = new ArrayList<String>();
        }
        if (oldUser.lastLoginDateList == null) {
            oldUser.lastLoginDateList = new ArrayList<LocalDateTime>();
        }
        oldUser.lastLoginDateList.add(LocalDateTime.now());
        oldUser.lastLoginIPList.add(NetUtils.getIpAddress((RoutingContext)ScxContext.routingContext()));
        User tempUser = new User();
        tempUser.lastLoginDateList = oldUser.lastLoginDateList.subList(Math.max(oldUser.lastLoginDateList.size() - 10, 0), oldUser.lastLoginDateList.size());
        tempUser.lastLoginIPList = oldUser.lastLoginIPList.subList(Math.max(oldUser.lastLoginIPList.size() - 10, 0), oldUser.lastLoginIPList.size());
        this.userService.update(tempUser, new Where().equal("id", (Object)userID));
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json changeUserAvatar(@FromBody String newAvatar) throws UnauthorizedException, SQLException {
        User loginUser = OrganizationAuth.getLoginUser();
        if (loginUser != null) {
            User l = new User();
            l.avatar = newAvatar;
            l.id = loginUser.id;
            User update = (User)this.userService.update(l);
            return Json.ok().put("item", (Object)update);
        }
        throw new UnauthorizedException();
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json changeUserUsername(@FromBody String newUsername, @FromBody String password) throws UnauthorizedException, SQLException {
        User loginUser = OrganizationAuth.getLoginUser();
        if (loginUser != null) {
            if (CryptoUtils.checkPassword((String)password, (String)loginUser.password)) {
                long count = this.userService.count(new Query().equal("username", (Object)newUsername).notEqual("id", (Object)loginUser.id));
                if (count == 0L) {
                    User l = new User();
                    l.username = newUsername;
                    l.id = loginUser.id;
                    User update = (User)this.userService.update(l);
                    return Json.ok().put("item", (Object)update);
                }
                return Json.fail((String)"username-already-exists");
            }
            return Json.fail((String)"password-wrong");
        }
        throw new UnauthorizedException();
    }

    @ScxMapping(method={HttpMethod.POST})
    public Json changeUserPassword(@FromBody String newPassword, @FromBody String oldPassword) throws UnauthorizedException, SQLException {
        User loginUser = OrganizationAuth.getLoginUser();
        if (loginUser != null) {
            if (CryptoUtils.checkPassword((String)oldPassword, (String)loginUser.password)) {
                User l = new User();
                l.password = CryptoUtils.encryptPassword((String)newPassword);
                l.id = loginUser.id;
                User update = (User)this.userService.update(l);
                return Json.ok().put("item", (Object)update);
            }
            return Json.fail((String)"password-wrong");
        }
        throw new UnauthorizedException();
    }
}

